/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.channel;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.MavenCoordinate;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="promote", sortOptions=false, hidden=true)
public class ChannelPromoteCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--manifest"})
    private Optional<String> name;
    @CommandLine.Option(names={"--archive"}, required=true)
    private Path archive;
    @CommandLine.Option(names={"--repository-url"}, descriptionKey="target-repository-url")
    private Optional<URL> url;
    @CommandLine.Option(names={"--dir"})
    private Optional<Path> directory;
    @CommandLine.Option(names={"-y", "--yes"})
    private boolean noPrompt;

    public ChannelPromoteCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Optional<MavenCoordinate> res;
        if (this.url.isEmpty()) {
            res = this.readSetting(a -> a.getChannels().stream().flatMap(c -> c.getRepositories().stream()).filter(c -> c.getId().equals("customization-repository")).map(r -> {
                try {
                    return new URL(r.getUrl());
                }
                catch (MalformedURLException e) {
                    throw ProsperoLogger.ROOT_LOGGER.invalidUrl(r.getUrl(), e);
                }
            }).findFirst());
            if (res.isPresent()) {
                this.url = res;
            } else {
                this.console.error(CliMessages.MESSAGES.noCustomizationConfigFound("--channel-name", "--repository-url"), new String[0]);
                return 2;
            }
        }
        if (this.name.isEmpty()) {
            res = this.readSetting(a -> a.getChannels().stream().map(Channel::getManifestCoordinate).filter(m -> m.getMaven() != null && m.getMaven().getGroupId().equals("custom.channels")).map(ChannelManifestCoordinate::getMaven).findFirst());
            if (res.isPresent()) {
                this.name = res.map(this::toGav);
            } else {
                this.console.error(CliMessages.MESSAGES.noCustomizationConfigFound("--channel-name", "--repository-url"), new String[0]);
                return 2;
            }
        }
        if (!this.isValidManifestCoordinate()) {
            this.console.error(CliMessages.MESSAGES.wrongChannelCoordinateFormat(), new String[0]);
            return 2;
        }
        ChannelManifestCoordinate coordinate = ArtifactUtils.manifestCoordFromString(this.name.get());
        boolean accepted = !this.noPrompt ? this.console.confirm(CliMessages.MESSAGES.continuePromote(), CliMessages.MESSAGES.continuePromoteAccepted(), CliMessages.MESSAGES.continuePromoteRejected()) : true;
        if (accepted) {
            this.actionFactory.promoter(this.console).promote(this.archive.normalize().toAbsolutePath(), this.url.get(), coordinate);
        }
        return 0;
    }

    private String toGav(MavenCoordinate coord) {
        String ga = coord.getGroupId() + ":" + coord.getArtifactId();
        if (coord.getVersion() != null && !coord.getVersion().isEmpty()) {
            return ga + ":" + coord.getVersion();
        }
        return ga;
    }

    private <T> Optional<T> readSetting(ThrowableFunction<MetadataAction, Optional<T>> reader) throws MetadataException {
        try {
            Optional<T> customChannel;
            Path installation = ChannelPromoteCommand.determineInstallationDirectory(this.directory);
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installation);){
                customChannel = reader.apply(metadataAction);
            }
            if (customChannel.isPresent()) {
                return customChannel;
            }
            return Optional.empty();
        }
        catch (ArgumentParsingException e) {
            return Optional.empty();
        }
    }

    private boolean isValidManifestCoordinate() {
        return !this.name.get().isEmpty() && ArtifactUtils.isValidCoordinate(this.name.get());
    }

    static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws MetadataException;
    }
}

