/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.wfchannel.ResolvedArtifactsStore;

public class ArtifactCache {
    private static final Logger LOG = Logger.getLogger(ArtifactCache.class);
    static final String CACHE_LINE_SEPARATOR = "::";
    static final String CACHE_FILENAME = "artifacts.txt";
    public static final Path CACHE_FOLDER = Path.of(".installation", ".cache");
    private final Path cacheDir;
    private final Path installationDir;
    private final Map<String, Path> paths = new HashMap<String, Path>();
    private final Map<String, String> hashes = new HashMap<String, String>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final HashMap<Path, ArtifactCache> instances = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactCache getInstance(Path installationDir) throws IOException {
        HashMap<Path, ArtifactCache> hashMap = instances;
        synchronized (hashMap) {
            if (!instances.containsKey(installationDir.toAbsolutePath())) {
                instances.put(installationDir.toAbsolutePath(), new ArtifactCache(installationDir));
            }
            return instances.get(installationDir.toAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanInstancesCache() {
        HashMap<Path, ArtifactCache> hashMap = instances;
        synchronized (hashMap) {
            instances.clear();
        }
    }

    private ArtifactCache(Path installationDir) throws IOException {
        this.installationDir = installationDir;
        this.cacheDir = installationDir.resolve(CACHE_FOLDER);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<File> getArtifact(String groupId, String artifactId, String extension, String classifier, String version) {
        String key = ArtifactCache.asKey(groupId, artifactId, extension, classifier, version);
        try {
            this.lock.readLock().lock();
            if (this.paths.containsKey(key)) {
                Path path;
                block9: {
                    path = this.paths.get(key);
                    try {
                        String hash = HashUtils.hashFile(path);
                        if (hash.equals(this.hashes.get(key))) break block9;
                        LOG.debug("Hashes don't match for " + key);
                        Optional<File> optional = Optional.empty();
                        return optional;
                    }
                    catch (IOException e) {
                        LOG.debug((Object)("Unable to calculate cached artifact hash " + key), e);
                        Optional<File> optional = Optional.empty();
                        return optional;
                    }
                }
                Optional<File> optional = Optional.of(path.toFile());
                return optional;
            }
            Optional<File> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(MavenArtifact artifact, Path pathToArtifact) throws IOException {
        try {
            this.lock.writeLock().lock();
            String cacheFileKey = ArtifactCache.getCacheFileKey(artifact);
            Path cacheList = this.cacheDir.resolve(CACHE_FILENAME);
            if (this.paths.containsKey(ArtifactCache.asKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion()))) {
                ArtifactCache.removeArtifactFromCacheList(cacheFileKey, cacheList);
            }
            String hash = HashUtils.hashFile(artifact.getFile().toPath());
            Path relativePath = this.installationDir.relativize(pathToArtifact);
            String recordedPath = relativePath.toString().replace(File.separatorChar, '/');
            Files.writeString(cacheList, (CharSequence)(cacheFileKey + CACHE_LINE_SEPARATOR + hash + CACHE_LINE_SEPARATOR + recordedPath + "\n"), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            this.invalidate();
            this.init();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void cache(MavenArtifact artifact) throws IOException {
        IoUtils.copy(artifact.getFile().toPath(), this.cacheDir.resolve(artifact.getFile().getName()), false);
        this.record(artifact, this.cacheDir.resolve(artifact.getFile().getName()));
    }

    public void cache(ManifestVersionRecord manifestRecord, ResolvedArtifactsStore resolvedArtifacts) throws IOException {
        Objects.requireNonNull(manifestRecord);
        Objects.requireNonNull(resolvedArtifacts);
        for (ManifestVersionRecord.MavenManifest manifest : manifestRecord.getMavenManifests()) {
            File cachedManifest;
            MavenArtifact record = resolvedArtifacts.getManifestVersion(manifest.getGroupId(), manifest.getArtifactId());
            if (record == null || !record.getVersion().equals(manifest.getVersion())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Adding manifest %s to the cache", (Object)record);
            }
            if (!(cachedManifest = record.getFile()).exists()) continue;
            this.cache(new MavenArtifact(manifest.getGroupId(), manifest.getArtifactId(), "yaml", "manifest", manifest.getVersion(), cachedManifest));
        }
    }

    private static String getCacheFileKey(MavenArtifact artifact) {
        org.jboss.galleon.universe.maven.MavenArtifact galleonArtifact = new org.jboss.galleon.universe.maven.MavenArtifact();
        galleonArtifact.setGroupId(artifact.getGroupId());
        galleonArtifact.setArtifactId(artifact.getArtifactId());
        galleonArtifact.setClassifier(artifact.getClassifier());
        galleonArtifact.setExtension(artifact.getExtension());
        galleonArtifact.setVersion(artifact.getVersion());
        return galleonArtifact.getCoordsAsString();
    }

    private static void removeArtifactFromCacheList(String cacheKey, Path cacheList) throws IOException {
        List<String> cacheLines = Files.readAllLines(cacheList);
        Files.delete(cacheList);
        try (BufferedWriter writer = Files.newBufferedWriter(cacheList, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
            for (String cacheLine : cacheLines) {
                if (cacheLine.split(CACHE_LINE_SEPARATOR)[0].equals(cacheKey)) continue;
                writer.write(cacheLine + System.lineSeparator());
            }
        }
    }

    private void init() throws IOException {
        Path artifactLog = this.cacheDir.resolve(CACHE_FILENAME);
        if (Files.exists(artifactLog, new LinkOption[0])) {
            int row;
            List<String> lines = Files.readAllLines(artifactLog);
            try {
                for (row = 0; row < lines.size(); ++row) {
                    String[] splitLine = lines.get(row).split(CACHE_LINE_SEPARATOR);
                    if (splitLine.length < 3) {
                        throw new IOException("Not enough segments, expected format is <GAV>::<hash>::<path>");
                    }
                    String gav = splitLine[0];
                    String hash = splitLine[1];
                    Path path = Paths.get(splitLine[2], new String[0]);
                    org.jboss.galleon.universe.maven.MavenArtifact mavenArtifact = org.jboss.galleon.universe.maven.MavenArtifact.fromString(gav);
                    String key = ArtifactCache.asKey(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getExtension(), mavenArtifact.getClassifier(), mavenArtifact.getVersion());
                    this.paths.put(key, this.installationDir.resolve(path));
                    this.hashes.put(key, hash);
                }
            }
            catch (IOException | MavenUniverseException e) {
                throw ProsperoLogger.ROOT_LOGGER.unableToReadArtifactCache(row + 1, lines.get(row), e);
            }
        }
    }

    private void invalidate() {
        this.paths.clear();
        this.hashes.clear();
    }

    private static String asKey(String groupId, String artifactId, String extension, String classifier, String version) {
        StringBuilder buf = new StringBuilder();
        buf.append(groupId).append(':').append(artifactId);
        if (version == null) {
            return buf.toString();
        }
        if (extension != null) {
            buf.append(':').append(extension);
        }
        if (classifier != null && !classifier.isEmpty()) {
            buf.append(':').append(classifier);
        }
        return buf.append(':').append(version).toString();
    }
}

