/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.XmlParsers;
import org.jboss.logging.Logger;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.LoggingMessageWriter;

public class GalleonUtils {
    public static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    protected static final String JBOSS_MODULES_SETTINGS_XML_URL = "jboss.modules.settings.xml.url";
    public static final String JBOSS_FORK_EMBEDDED_PROPERTY = "jboss-fork-embedded";
    public static final String JBOSS_FORK_EMBEDDED_VALUE = "true";
    public static final String JBOSS_BULK_RESOLVE_PROPERTY = "jboss-bulk-resolve-artifacts";
    public static final String JBOSS_BULK_RESOLVE_VALUE = "true";
    public static final String MODULE_PATH_PROPERTY = "module.path";
    public static final String PRINT_ONLY_CONFLICTS_PROPERTY = "print-only-conflicts";
    public static final String PRINT_ONLY_CONFLICTS_VALUE = "true";
    public static final String STORE_INPUT_PROVISIONING_CONFIG_PROPERTY = "store-input-provisioning-config";
    public static final String STORE_INPUT_PROVISIONING_CONFIG_VALUE = "true";
    public static final String STORE_PROVISIONED_ARTIFACTS = "jboss-resolved-artifacts-cache";
    public static final String STORE_PROVISIONED_ARTIFACTS_VALUE = ArtifactCache.CACHE_FOLDER.toString().replace(File.separatorChar, '/');
    private static final String CLASSPATH_SCHEME = "classpath";
    private static final String FILE_SCHEME = "file";
    private static final String OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES = "jboss-reset-embedded-system-properties";
    private static final Logger logger = Logger.getLogger(GalleonUtils.class.getName());

    public static void executeGalleon(GalleonExecution execution, Path localRepository) throws ProvisioningException, UnresolvedMavenArtifactException {
        HashMap<String, String> substitutedProperties = new HashMap<String, String>();
        try {
            substitutedProperties.putAll(GalleonUtils.substituteProvisioningProperties(localRepository));
            HashMap<String, String> options = new HashMap<String, String>();
            options.put(JBOSS_FORK_EMBEDDED_PROPERTY, "true");
            options.put(JBOSS_BULK_RESOLVE_PROPERTY, "true");
            options.put(PRINT_ONLY_CONFLICTS_PROPERTY, "true");
            options.put(STORE_INPUT_PROVISIONING_CONFIG_PROPERTY, "true");
            options.put(STORE_PROVISIONED_ARTIFACTS, STORE_PROVISIONED_ARTIFACTS_VALUE);
            String resetSysProp = System.getProperty(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES, "");
            if (!resetSysProp.equals("-")) {
                options.put(OPTION_RESET_EMBEDDED_SYSTEM_PROPERTIES, resetSysProp);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Executing galleon");
                logger.trace("System properties:");
                for (Object object : System.getProperties().keySet()) {
                    logger.trace("  " + object + ": " + System.getProperties().get(object));
                }
                logger.trace("System envs:");
                for (String string : System.getenv().keySet()) {
                    logger.trace("  " + string + ": " + System.getenv().get(string));
                }
                logger.trace("Galleon options:");
                for (String string : options.keySet()) {
                    logger.trace("  " + string + ": " + (String)options.get(string));
                }
            }
            execution.execute(options);
        }
        catch (ProvisioningException e) {
            throw GalleonUtils.extractMavenException(e).orElseThrow(() -> e);
        }
        finally {
            try {
                Path tempSettingsXml = Path.of(new URL(System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL)).toURI());
                FileUtils.deleteQuietly(tempSettingsXml.toFile());
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException("Unable to delete a temporary settings.xml file " + System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL), e);
            }
            for (Map.Entry property : substitutedProperties.entrySet()) {
                if (property.getValue() == null) {
                    System.clearProperty((String)property.getKey());
                    continue;
                }
                System.setProperty((String)property.getKey(), (String)property.getValue());
            }
        }
    }

    private static Map<String, String> substituteProvisioningProperties(Path localRepository) throws ProvisioningException {
        HashMap<String, String> substitutedProperties = new HashMap<String, String>();
        substitutedProperties.put(MAVEN_REPO_LOCAL, System.getProperty(MAVEN_REPO_LOCAL));
        System.setProperty(MAVEN_REPO_LOCAL, localRepository.toString());
        if (System.getProperty(MODULE_PATH_PROPERTY) != null) {
            substitutedProperties.put(MODULE_PATH_PROPERTY, System.getProperty(MODULE_PATH_PROPERTY));
            System.clearProperty(MODULE_PATH_PROPERTY);
        }
        if (System.getProperty("logging.configuration") != null) {
            substitutedProperties.put("logging.configuration", System.getProperty("logging.configuration"));
            System.clearProperty("logging.configuration");
        }
        try {
            substitutedProperties.put(JBOSS_MODULES_SETTINGS_XML_URL, System.getProperty(JBOSS_MODULES_SETTINGS_XML_URL));
            Path tempSettingsXml = Files.createTempFile("prospero-maven-settings", "xml", new FileAttribute[0]);
            Files.writeString(tempSettingsXml, (CharSequence)"<settings/>", new OpenOption[0]);
            System.setProperty(JBOSS_MODULES_SETTINGS_XML_URL, tempSettingsXml.toUri().toURL().toExternalForm());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        return substitutedProperties;
    }

    private static Optional<UnresolvedMavenArtifactException> extractMavenException(Throwable e) {
        if (e instanceof UnresolvedMavenArtifactException) {
            return Optional.of((UnresolvedMavenArtifactException)e);
        }
        if (e.getCause() != null) {
            return GalleonUtils.extractMavenException(e.getCause());
        }
        return Optional.empty();
    }

    public static ProvisioningManager getProvisioningManager(Path installDir, MavenRepoManager maven, final Consumer<String> resolvedFps) throws ProvisioningException {
        if (resolvedFps != null) {
            UniverseResolver.Builder builder = (UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(maven);
            UniverseResolver universeResolver = new UniverseResolver(builder){

                @Override
                public Path resolve(FeaturePackLocation fpl) throws ProvisioningException {
                    if (fpl.isMavenCoordinates()) {
                        String[] split = fpl.getFPID().getProducer().getName().split(":");
                        resolvedFps.accept(split[0] + ":" + split[1]);
                    }
                    return super.resolve(fpl);
                }
            };
            return ProvisioningManager.builder().setMessageWriter(new LoggingMessageWriter(logger)).setUniverseResolver(universeResolver).setInstallationHome(installDir).build();
        }
        return ((ProvisioningManager.Builder)ProvisioningManager.builder().setMessageWriter(new LoggingMessageWriter(logger)).addArtifactResolver(maven)).setInstallationHome(installDir).build();
    }

    public static ProvisioningLayoutFactory getProvisioningLayoutFactory(MavenRepoManager maven) throws ProvisioningException {
        UniverseResolver resolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(maven)).build();
        return ProvisioningLayoutFactory.getInstance(resolver);
    }

    public static List<String> getInstalledPacks(Path dir) throws ProvisioningException {
        Collection<ProvisionedFeaturePack> featurePacks = ProvisionedStateXmlParser.parse(PathsUtils.getProvisionedStateXml(dir)).getFeaturePacks();
        return featurePacks.stream().map(fp -> fp.getFPID().getProducer().getName()).collect(Collectors.toList());
    }

    public static ProvisioningConfig loadProvisioningConfig(InputStream is) throws ProvisioningException, XMLStreamException {
        InputStreamReader reader = new InputStreamReader(is);
        ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
        XmlParsers.parse(reader, builder);
        return builder.build();
    }

    public static ProvisioningConfig loadProvisioningConfig(URI uri) throws ProvisioningException, XMLStreamException {
        if (CLASSPATH_SCHEME.equals(uri.getScheme())) {
            InputStream is = GalleonUtils.class.getClassLoader().getResourceAsStream(uri.getSchemeSpecificPart());
            return GalleonUtils.loadProvisioningConfig(is);
        }
        if (FILE_SCHEME.equals(uri.getScheme())) {
            return ProvisioningXmlParser.parse(Path.of(uri));
        }
        throw new IllegalArgumentException(String.format("Can't use scheme '%s' for Galleon provisioning.xml URI.", uri.getScheme()));
    }

    public static interface ProvisioningManagerExecution {
        public void execute(ProvisioningManager var1, Map<String, String> var2) throws ProvisioningException;
    }

    public static interface GalleonExecution {
        public void execute(Map<String, String> var1) throws ProvisioningException;
    }
}

