/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

public class ProsperoMetadataUtils {
    public static final String METADATA_DIR = ".installation";
    public static final String MANIFEST_FILE_NAME = "manifest.yaml";
    public static final String INSTALLER_CHANNELS_FILE_NAME = "installer-channels.yaml";
    public static final String MAVEN_OPTS_FILE = "maven_opts.yaml";
    public static final String CURRENT_VERSION_FILE = "manifest_version.yaml";
    public static final String README_FILE_NAME = "README.txt";
    public static final String PROVISIONING_RECORD_XML = "provisioning_record.xml";
    private static final String WARNING_MESSAGE = "WARNING: The files in .installation directory should be only edited by the provisioning tool.";

    public static void generate(Path serverDir, List<Channel> channels, ChannelManifest manifest, ManifestVersionRecord versionRecord) throws IOException {
        Objects.requireNonNull(serverDir);
        Objects.requireNonNull(channels);
        Objects.requireNonNull(manifest);
        Path metadataDir = serverDir.resolve(METADATA_DIR);
        Path manifestPath = metadataDir.resolve(MANIFEST_FILE_NAME);
        Path configPath = metadataDir.resolve(INSTALLER_CHANNELS_FILE_NAME);
        Path versionRecordPath = metadataDir.resolve(CURRENT_VERSION_FILE);
        Path readmeFile = metadataDir.resolve(README_FILE_NAME);
        if (Files.exists(metadataDir, new LinkOption[0]) && !Files.isDirectory(metadataDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The target path %s is not a directory.", metadataDir));
        }
        if (Files.exists(manifestPath, new LinkOption[0]) || Files.exists(configPath, new LinkOption[0])) {
            throw new IllegalArgumentException("Metadata files are already present at " + metadataDir);
        }
        if (!Files.exists(metadataDir, new LinkOption[0])) {
            Files.createDirectory(metadataDir, new FileAttribute[0]);
        }
        ProsperoMetadataUtils.writeManifest(manifestPath, manifest);
        ProsperoMetadataUtils.writeChannelsConfiguration(configPath, channels);
        if (versionRecord != null) {
            ProsperoMetadataUtils.writeVersionRecord(versionRecordPath, versionRecord);
        }
        ProsperoMetadataUtils.recordProvisioningDefinition(serverDir);
        if (!Files.exists(readmeFile, new LinkOption[0])) {
            ProsperoMetadataUtils.writeWarningReadme(readmeFile);
        }
    }

    public static void writeChannelsConfiguration(Path channelPath, List<Channel> channels) throws IOException {
        Objects.requireNonNull(channelPath);
        Objects.requireNonNull(channels);
        if (!Files.exists(channelPath.getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The target path %s does not exist.", channelPath.getParent()));
        }
        ProsperoMetadataUtils.writeToFile(channelPath, ChannelMapper.toYaml(channels));
    }

    public static void writeManifest(Path manifestPath, ChannelManifest manifest) throws IOException {
        Objects.requireNonNull(manifestPath);
        Objects.requireNonNull(manifest);
        if (!Files.exists(manifestPath.getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The target path %s does not exist.", manifestPath.getParent()));
        }
        ProsperoMetadataUtils.writeToFile(manifestPath, ChannelManifestMapper.toYaml(manifest));
    }

    public static void writeVersionRecord(Path versionsPath, ManifestVersionRecord versionRecord) throws IOException {
        Objects.requireNonNull(versionRecord);
        Objects.requireNonNull(versionsPath);
        if (!Files.exists(versionsPath.getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The target path %s does not exist.", versionsPath.getParent()));
        }
        String yaml = ManifestVersionRecord.toYaml(versionRecord);
        if (Files.exists(versionsPath, new LinkOption[0])) {
            Files.delete(versionsPath);
        }
        Files.writeString(versionsPath, (CharSequence)yaml, new OpenOption[0]);
    }

    public static void writeWarningReadme(Path readmeFile) throws IOException {
        Objects.requireNonNull(readmeFile);
        if (!Files.exists(readmeFile.getParent(), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The target path %s does not exist.", readmeFile.getParent()));
        }
        ProsperoMetadataUtils.writeToFile(readmeFile, WARNING_MESSAGE);
    }

    public static Path manifestPath(Path serverDir) {
        return serverDir.resolve(METADATA_DIR).resolve(MANIFEST_FILE_NAME);
    }

    public static Path configurationPath(Path serverDir) {
        return serverDir.resolve(METADATA_DIR).resolve(INSTALLER_CHANNELS_FILE_NAME);
    }

    public static void recordProvisioningDefinition(Path sourceServer) throws IOException {
        Path provisioningFile = sourceServer.resolve(".galleon").resolve("provisioning.xml");
        Path provisioningRecordFile = sourceServer.resolve(METADATA_DIR).resolve(PROVISIONING_RECORD_XML);
        if (!Files.exists(provisioningFile, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(provisioningRecordFile, new LinkOption[0])) {
            String content = Files.readString(provisioningFile);
            String lineEndings = content.replaceAll("\\r\\n?", "\n");
            Files.writeString(provisioningRecordFile, (CharSequence)lineEndings, new OpenOption[0]);
        } else if (!ProsperoMetadataUtils.isFileContentEquals(provisioningFile, provisioningRecordFile)) {
            String content = Files.readString(provisioningFile);
            String lineEndings = content.replaceAll("\\r\\n?", "\n");
            Files.writeString(provisioningRecordFile, (CharSequence)lineEndings, new OpenOption[0]);
        }
    }

    static boolean isFileContentEquals(Path path1, Path path2) throws IOException {
        try (BufferedReader bf1 = Files.newBufferedReader(path1);){
            boolean bl;
            block20: {
                BufferedReader bf2;
                block18: {
                    boolean bl2;
                    block19: {
                        boolean bl3;
                        bf2 = Files.newBufferedReader(path2);
                        try {
                            String line1 = "";
                            String line2 = "";
                            while ((line1 = bf1.readLine()) != null) {
                                line2 = bf2.readLine();
                                if (line1.equals(line2)) continue;
                                bl3 = false;
                                if (bf2 == null) break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (bf2 != null) {
                                try {
                                    bf2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        {
                            block17: {
                                bf2.close();
                            }
                            return bl3;
                        }
                        if (bf2.readLine() != null) break block18;
                        bl2 = true;
                        if (bf2 == null) break block19;
                        bf2.close();
                    }
                    return bl2;
                }
                bl = false;
                if (bf2 == null) break block20;
                bf2.close();
            }
            return bl;
        }
    }

    protected static void writeToFile(Path path, String text) throws IOException {
        if (!((String)text).endsWith("\n")) {
            text = (String)text + "\n";
        }
        Files.writeString(path, (CharSequence)text, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

