/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class ConfigXmlWriter
extends BaseXmlWriter<ConfigModel> {
    private static final ConfigXmlWriter INSTANCE = new ConfigXmlWriter();

    public static ConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ConfigXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ConfigModel config) {
        return this.toElement(config, "urn:jboss:galleon:config:1.0");
    }

    protected ElementNode toElement(ConfigModel config, String ns) {
        ElementNode layer;
        ElementNode configE = ConfigXmlWriter.addElement(null, ConfigXml.Element.CONFIG.getLocalName(), ns);
        if (config.getModel() != null) {
            ConfigXmlWriter.addAttribute(configE, ConfigXml.Attribute.MODEL, config.getModel());
        }
        if (config.hasProperties()) {
            ElementNode propsE = ConfigXmlWriter.addElement(configE, ConfigXml.Element.PROPS.getLocalName(), ns);
            for (Map.Entry<String, Object> entry : config.getProperties().entrySet()) {
                ElementNode propE = ConfigXmlWriter.addElement(propsE, ConfigXml.Element.PROP.getLocalName(), ns);
                ConfigXmlWriter.addAttribute(propE, ConfigXml.Attribute.NAME, entry.getKey());
                ConfigXmlWriter.addAttribute(propE, ConfigXml.Attribute.VALUE, (String)entry.getValue());
            }
        }
        if (config.hasConfigDeps()) {
            ElementNode configDeps = ConfigXmlWriter.addElement(configE, ConfigXml.Element.CONFIG_DEPS.getLocalName(), ns);
            for (Map.Entry entry : config.getConfigDeps().entrySet()) {
                ElementNode configDep = ConfigXmlWriter.addElement(configDeps, ConfigXml.Element.CONFIG_DEP.getLocalName(), ns);
                ConfigXmlWriter.addAttribute(configDep, ConfigXml.Attribute.ID.getLocalName(), (String)entry.getKey());
                ConfigId configId = (ConfigId)entry.getValue();
                if (configId.getModel() != null) {
                    ConfigXmlWriter.addAttribute(configDep, ConfigXml.Attribute.MODEL.getLocalName(), configId.getModel());
                }
                if (configId.getName() == null) continue;
                ConfigXmlWriter.addAttribute(configDep, ConfigXml.Attribute.NAME.getLocalName(), configId.getName());
            }
        }
        ElementNode layers = null;
        if (!config.isInheritLayers()) {
            layers = ConfigXmlWriter.addElement(configE, ConfigXml.Element.LAYERS.getLocalName(), ns);
            ConfigXmlWriter.addAttribute(layers, ConfigXml.Attribute.INHERIT, "false");
        }
        if (config.hasIncludedLayers()) {
            if (layers == null) {
                layers = ConfigXmlWriter.addElement(configE, ConfigXml.Element.LAYERS.getLocalName(), ns);
            }
            for (String string : config.getIncludedLayers()) {
                layer = ConfigXmlWriter.addElement(layers, ConfigXml.Element.INCLUDE.getLocalName(), ns);
                ConfigXmlWriter.addAttribute(layer, ConfigXml.Attribute.NAME, string);
            }
        }
        if (config.hasExcludedLayers()) {
            if (layers == null) {
                layers = ConfigXmlWriter.addElement(configE, ConfigXml.Element.LAYERS.getLocalName(), ns);
            }
            for (String string : config.getExcludedLayers()) {
                layer = ConfigXmlWriter.addElement(layers, ConfigXml.Element.EXCLUDE.getLocalName(), ns);
                ConfigXmlWriter.addAttribute(layer, ConfigXml.Attribute.NAME, string);
            }
        }
        FeatureGroupXmlWriter.addFeatureGroupDepBody(config, configE, ns);
        return configE;
    }
}

