/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.artifact.Artifact;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.layout.SystemPaths;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyStageBackup;
import org.wildfly.prospero.actions.InstallFolderUtils;
import org.wildfly.prospero.api.ArtifactChange;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.ApplyCandidateException;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.installation.git.GitStorage;
import org.wildfly.prospero.licenses.LicenseManager;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;
import org.wildfly.prospero.updates.MarkerFile;
import org.wildfly.prospero.updates.UpdateSet;

public class ApplyCandidateAction {
    public static final Path STANDALONE_STARTUP_MARKER = Path.of("standalone", "tmp", "startup-marker");
    public static final Path DOMAIN_STARTUP_MARKER = Path.of("domain", "tmp", "startup-marker");
    private final Path updateDir;
    private final Path installationDir;
    private final SystemPaths systemPaths;

    public ApplyCandidateAction(Path installationDir, Path updateDir) throws ProvisioningException, OperationException {
        this.updateDir = InstallFolderUtils.toRealPath(updateDir);
        this.installationDir = InstallFolderUtils.toRealPath(installationDir);
        try {
            this.systemPaths = SystemPaths.load(this.updateDir);
        }
        catch (IOException ex) {
            throw new ProvisioningException(ex);
        }
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("System paths " + this.systemPaths.getPaths());
        }
    }

    public List<FileConflict> applyUpdate(Type operation) throws ProvisioningException, OperationException {
        ValidationResult validationResult = this.verifyCandidate(operation);
        if (operation == Type.REVERT && ValidationResult.NO_CHANGES == validationResult) {
            InvalidUpdateCandidateException ex = ProsperoLogger.ROOT_LOGGER.noChangesAvailable(this.updateDir, this.installationDir);
            ProsperoLogger.ROOT_LOGGER.warn("", ex);
            throw ex;
        }
        if (ValidationResult.OK != validationResult) {
            InvalidUpdateCandidateException ex = ProsperoLogger.ROOT_LOGGER.invalidUpdateCandidate(this.updateDir, this.installationDir);
            ProsperoLogger.ROOT_LOGGER.warn("", ex);
            throw ex;
        }
        if (this.targetServerIsRunning()) {
            ProvisioningException ex = ProsperoLogger.ROOT_LOGGER.serverRunningError();
            ProsperoLogger.ROOT_LOGGER.warn("", ex);
            throw ex;
        }
        FsDiff diffs = GalleonUtils.findChanges(this.installationDir);
        ApplyStageBackup backup = null;
        try {
            backup = new ApplyStageBackup(this.installationDir, this.updateDir);
            backup.recordAll();
            ProsperoLogger.ROOT_LOGGER.debug("Update backup generated in " + this.installationDir.resolve(".update.old"));
            ProsperoLogger.ROOT_LOGGER.applyingCandidate(operation.text.toLowerCase(Locale.ROOT), this.updateDir);
            ProsperoLogger.ROOT_LOGGER.candidateChanges(this.findUpdates().getArtifactUpdates().stream().map(ArtifactChange::prettyPrint).collect(Collectors.joining("; ")));
            List<FileConflict> conflicts = this.doApplyUpdate(diffs);
            if (conflicts.isEmpty()) {
                ProsperoLogger.ROOT_LOGGER.noCandidateConflicts();
            } else {
                ProsperoLogger.ROOT_LOGGER.candidateConflicts(conflicts.stream().map(FileConflict::prettyPrint).collect(Collectors.joining("; ")));
                for (FileConflict conflict : conflicts) {
                    ProsperoLogger.ROOT_LOGGER.info(conflict.prettyPrint());
                }
            }
            this.updateMetadata(operation);
            ProsperoLogger.ROOT_LOGGER.candidateApplied(operation.text, this.installationDir);
            backup.close();
            return conflicts;
        }
        catch (IOException ex) {
            boolean backupRestored = false;
            try {
                if (backup != null) {
                    backup.restore();
                    backup.close();
                    backupRestored = true;
                }
            }
            catch (IOException e) {
                ProsperoLogger.ROOT_LOGGER.error("Unable to restore the server from a backup, preserving the backup.", e);
            }
            String msg = ex.getLocalizedMessage() == null ? ex.getMessage() : ex.getLocalizedMessage();
            throw new ApplyCandidateException(ProsperoLogger.ROOT_LOGGER.failedToApplyCandidate(msg), backupRestored, this.installationDir.resolve(".update.old"), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ValidationResult verifyCandidate(Type operation) throws MetadataException {
        MarkerFile marker;
        Path updateMarkerPath = this.updateDir.resolve(MarkerFile.UPDATE_MARKER_FILE);
        if (!Files.exists(updateMarkerPath, new LinkOption[0])) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) return ValidationResult.NOT_CANDIDATE;
            ProsperoLogger.ROOT_LOGGER.debugf("The candidate [%s] doesn't have a marker file", (Object)this.updateDir);
            return ValidationResult.NOT_CANDIDATE;
        }
        try {
            marker = MarkerFile.read(this.updateDir);
            String hash = marker.getState();
            try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.installationDir);){
                if (!metadata.getRevisions().get(0).getName().equals(hash)) {
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debugf("The installation state has changed from the candidate [%s].", (Object)this.updateDir);
                    }
                    ValidationResult validationResult = ValidationResult.STALE;
                    return validationResult;
                }
            }
        }
        catch (IOException e) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(updateMarkerPath, e);
            ProsperoLogger.ROOT_LOGGER.debugf("Unable to read marker file [%s].", (Object)this.updateDir);
            throw ProsperoLogger.ROOT_LOGGER.unableToReadFile(updateMarkerPath, e);
        }
        if (marker.getOperation() != operation) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) return ValidationResult.WRONG_TYPE;
            ProsperoLogger.ROOT_LOGGER.debugf("The candidate server has been prepared for different operation [%s].", (Object)marker.getOperation().getText());
            return ValidationResult.WRONG_TYPE;
        }
        try {
            if (operation != Type.REVERT) return ValidationResult.OK;
            if (!ApplyCandidateAction.compareContent(this.installationDir, this.updateDir)) return ValidationResult.OK;
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) return ValidationResult.NO_CHANGES;
            ProsperoLogger.ROOT_LOGGER.debugf("There are no changes to apply to the installation [%s] from the candidate installation [%s].", (Object)this.installationDir, (Object)this.updateDir);
            return ValidationResult.NO_CHANGES;
        }
        catch (IOException e) {
            if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) throw ProsperoLogger.ROOT_LOGGER.unableToCompareHashDirs(this.installationDir, this.updateDir, e);
            ProsperoLogger.ROOT_LOGGER.debugf("IO Error comparing [%s] and [%s] hashes content.", (Object)this.installationDir, (Object)this.updateDir);
            throw ProsperoLogger.ROOT_LOGGER.unableToCompareHashDirs(this.installationDir, this.updateDir, e);
        }
    }

    public List<FileConflict> getConflicts() throws ProvisioningException, OperationException {
        try {
            return this.compareServers(GalleonUtils.findChanges(this.installationDir));
        }
        catch (IOException ex) {
            throw new ProvisioningException(ex);
        }
    }

    public void removeUpdateCandidate(boolean remove) {
        if (remove) {
            this.removeCandidate(this.updateDir.toFile());
        }
    }

    boolean removeCandidate(File updateDir) {
        File[] allContents = updateDir.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.removeCandidate(file);
            }
        }
        return updateDir.delete();
    }

    public UpdateSet findUpdates() throws OperationException {
        List<Artifact> candidate;
        List<Artifact> base;
        HashMap<CallSite, Artifact> baseMap = new HashMap<CallSite, Artifact>();
        HashMap<CallSite, Artifact> candidateMap = new HashMap<CallSite, Artifact>();
        try (Iterator<Artifact> metadata = InstallationMetadata.loadInstallation(this.installationDir);){
            base = ((InstallationMetadata)((Object)metadata)).getArtifacts();
        }
        metadata = InstallationMetadata.loadInstallation(this.updateDir);
        try {
            candidate = ((InstallationMetadata)((Object)metadata)).getArtifacts();
        }
        finally {
            if (metadata != null) {
                ((InstallationMetadata)((Object)metadata)).close();
            }
        }
        for (Artifact artifact : base) {
            baseMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
        }
        for (Artifact artifact : candidate) {
            candidateMap.put((CallSite)((Object)(artifact.getGroupId() + ":" + artifact.getArtifactId())), artifact);
        }
        ArrayList<ArtifactChange> changes = new ArrayList<ArtifactChange>();
        for (String key : baseMap.keySet()) {
            if (candidateMap.containsKey(key)) {
                if (((Artifact)baseMap.get(key)).getVersion().equals(((Artifact)candidateMap.get(key)).getVersion())) continue;
                changes.add(ArtifactChange.updated((Artifact)baseMap.get(key), (Artifact)candidateMap.get(key)));
                continue;
            }
            changes.add(ArtifactChange.removed((Artifact)baseMap.get(key)));
        }
        for (String key : candidateMap.keySet()) {
            if (baseMap.containsKey(key)) continue;
            changes.add(ArtifactChange.added((Artifact)candidateMap.get(key)));
        }
        return new UpdateSet(changes);
    }

    public SavedState getCandidateRevision() throws MetadataException {
        try (InstallationMetadata metadata = InstallationMetadata.loadInstallation(this.updateDir);){
            SavedState savedState = metadata.getRevisions().get(0);
            return savedState;
        }
    }

    private boolean targetServerIsRunning() {
        return Files.exists(this.installationDir.resolve(STANDALONE_STARTUP_MARKER), new LinkOption[0]) || Files.exists(this.installationDir.resolve(DOMAIN_STARTUP_MARKER), new LinkOption[0]);
    }

    private void updateMetadata(Type operation) throws IOException, MetadataException {
        this.copyCurrentVersions();
        Path installationGalleonPath = PathsUtils.getProvisionedStateDir(this.installationDir);
        Path updateGalleonPath = PathsUtils.getProvisionedStateDir(this.updateDir);
        IoUtils.recursiveDelete(installationGalleonPath);
        IoUtils.copy(updateGalleonPath, installationGalleonPath, true);
        ProsperoMetadataUtils.recordProvisioningDefinition(this.installationDir);
        this.writeProsperoMetadata(operation);
        this.updateInstallationCache();
        this.updateAcceptedLicences();
    }

    private void updateAcceptedLicences() throws MetadataException {
        try {
            new LicenseManager().copyIfExists(this.updateDir, this.installationDir);
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToWriteFile(this.installationDir.resolve("licenses"), e);
        }
    }

    private void copyCurrentVersions() throws IOException {
        Path sourceVersions = this.updateDir.resolve(".installation").resolve("manifest_version.yaml");
        if (Files.exists(sourceVersions, new LinkOption[0])) {
            Files.copy(sourceVersions, this.installationDir.resolve(".installation").resolve("manifest_version.yaml"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeProsperoMetadata(Type operation) throws MetadataException, IOException {
        Path updateMetadataDir = this.updateDir.resolve(".installation");
        Path updateManifest = updateMetadataDir.resolve("manifest.yaml");
        Path installationMetadataDir = this.installationDir.resolve(".installation");
        Path installationManifest = installationMetadataDir.resolve("manifest.yaml");
        IoUtils.copy(updateManifest, installationManifest);
        try (GitStorage git = new GitStorage(this.installationDir);){
            switch (operation) {
                case UPDATE: {
                    git.recordChange(SavedState.Type.UPDATE);
                    return;
                }
                case REVERT: {
                    git.recordChange(SavedState.Type.ROLLBACK);
                    Path updateChannels = updateMetadataDir.resolve("installer-channels.yaml");
                    Path installationChannels = installationMetadataDir.resolve("installer-channels.yaml");
                    ApplyCandidateAction.copyFiles(updateChannels, installationChannels);
                    return;
                }
                case FEATURE_ADD: {
                    git.recordChange(SavedState.Type.FEATURE_PACK);
                    return;
                }
            }
            return;
        }
    }

    private static void copyFiles(Path source, Path target) throws IOException {
        if (Files.exists(target, new LinkOption[0])) {
            FileUtils.deleteQuietly(target.toFile());
        }
        IoUtils.copy(source, target);
    }

    private void updateInstallationCache() throws IOException {
        Path updateCacheDir = this.updateDir.resolve(ArtifactCache.CACHE_FOLDER);
        Path installationCacheDir = this.installationDir.resolve(ArtifactCache.CACHE_FOLDER);
        if (Files.exists(installationCacheDir, new LinkOption[0])) {
            IoUtils.recursiveDelete(installationCacheDir);
        }
        if (Files.exists(updateCacheDir, new LinkOption[0])) {
            ApplyCandidateAction.copyFiles(updateCacheDir, installationCacheDir);
        }
    }

    private List<FileConflict> handleRemovedFiles(FsDiff fsDiff) throws IOException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasRemovedEntries()) {
            for (FsEntry removed : fsDiff.getRemovedEntries()) {
                Path target = this.updateDir.resolve(removed.getRelativePath());
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('-', removed.getRelativePath(), null));
                }
                if (Files.exists(target, new LinkOption[0])) {
                    if (!this.systemPaths.isSystemPath(Paths.get(removed.getRelativePath(), new String[0]))) continue;
                    conflictList.add(FileConflict.userRemoved(removed.getRelativePath()).updateModified().overwritten());
                    if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) continue;
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('F', removed.getRelativePath(), "has changed in the updated version"));
                    continue;
                }
                if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) continue;
                ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('-', removed.getRelativePath(), "has been removed from the updated version"));
            }
        }
        return conflictList;
    }

    private List<FileConflict> handleAddedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasAddedEntries()) {
            for (FsEntry added : fsDiff.getAddedEntries()) {
                Path p = Paths.get(added.getRelativePath(), new String[0]);
                if (p.getNameCount() > 0 && p.getName(0).toString().equals(".installation")) continue;
                this.addFsEntry(this.updateDir, added, this.systemPaths, conflictList);
            }
        }
        return conflictList;
    }

    private void addFsEntry(Path updateDir, FsEntry added, SystemPaths systemPaths, List<FileConflict> conflictList) throws ProvisioningException {
        Path target = updateDir.resolve(added.getRelativePath());
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('+', added.getRelativePath(), null));
        }
        if (Files.exists(target, new LinkOption[0])) {
            byte[] targetHash;
            if (added.isDir()) {
                for (FsEntry child : added.getChildren()) {
                    this.addFsEntry(updateDir, child, systemPaths, conflictList);
                }
                return;
            }
            try {
                targetHash = HashUtils.hashPath(target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.hashCalculation(target), e);
            }
            if (Arrays.equals(added.getHash(), targetHash)) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('+', added.getRelativePath(), "Added file matches the update."));
                }
            } else if (systemPaths.isSystemPath(Paths.get(added.getRelativePath(), new String[0]))) {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('F', added.getRelativePath(), "conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().overwritten());
            } else {
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('C', added.getRelativePath(), "conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().userPreserved());
            }
        }
    }

    private List<FileConflict> handleModifiedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasModifiedEntries()) {
            for (FsEntry[] modified : fsDiff.getModifiedEntries()) {
                FsEntry installation = modified[1];
                FsEntry original = modified[0];
                Path file = this.updateDir.resolve(modified[1].getRelativePath());
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('M', installation.getRelativePath(), null));
                }
                if (Files.exists(file, new LinkOption[0])) {
                    byte[] updateHash;
                    try {
                        updateHash = HashUtils.hashPath(file);
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.hashCalculation(file), e);
                    }
                    if (Arrays.equals(installation.getHash(), updateHash)) {
                        if (!ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) continue;
                        ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('M', installation.getRelativePath(), "Modified file matches the update"));
                        continue;
                    }
                    if (Arrays.equals(original.getHash(), updateHash)) continue;
                    if (this.systemPaths.isSystemPath(Paths.get(installation.getRelativePath(), new String[0]))) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('F', installation.getRelativePath(), "has changed in the updated version"));
                        }
                        conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().overwritten());
                        continue;
                    }
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('C', installation.getRelativePath(), "has changed in the updated version"));
                    }
                    conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().userPreserved());
                    continue;
                }
                if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.debug(FsDiff.formatMessage('M', installation.getRelativePath(), "has been removed from the updated version"));
                }
                conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateRemoved().userPreserved());
            }
        }
        return conflictList;
    }

    private List<FileConflict> compareServers(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflicts = new ArrayList<FileConflict>();
        conflicts.addAll(this.handleRemovedFiles(fsDiff));
        conflicts.addAll(this.handleAddedFiles(fsDiff));
        conflicts.addAll(this.handleModifiedFiles(fsDiff));
        return Collections.unmodifiableList(conflicts);
    }

    private List<FileConflict> doApplyUpdate(final FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflicts = new ArrayList<FileConflict>();
        conflicts.addAll(this.handleRemovedFiles(fsDiff));
        conflicts.addAll(this.handleAddedFiles(fsDiff));
        conflicts.addAll(this.handleModifiedFiles(fsDiff));
        this.resolveFileConflicts(conflicts);
        final Path skipUpdateGalleon = PathsUtils.getProvisionedStateDir(this.updateDir);
        final Path skipUpdateInstallation = this.updateDir.resolve(".installation");
        final Path skipInstallationGalleon = PathsUtils.getProvisionedStateDir(this.installationDir);
        final Path skipInstallationInstallation = this.installationDir.resolve(".installation");
        Files.walkFileTree(this.updateDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.updateDir.relativize(file);
                Path installationFile = ApplyCandidateAction.this.installationDir.resolve(relative);
                String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (fsDiff.getModifiedEntry(pathKey) == null && fsDiff.getAddedEntry(pathKey) == null && !this.isParentAdded(fsDiff, relative)) {
                    byte[] updateHash = HashUtils.hashPath(file);
                    if (!Files.exists(installationFile, new LinkOption[0]) || !Arrays.equals(updateHash, HashUtils.hashPath(installationFile))) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("Copying updated file " + relative + " to the installation");
                        }
                        ApplyCandidateAction.copyFiles(file, installationFile);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isParentAdded(FsDiff fsDiff2, Path relative) {
                for (Path parent = relative.getParent(); parent != null; parent = parent.getParent()) {
                    if (fsDiff2.getAddedEntry(parent + "/") == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(skipUpdateGalleon) || dir.equals(skipUpdateInstallation)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Files.walkFileTree(this.installationDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.installationDir.relativize(file);
                Path updateFile = ApplyCandidateAction.this.updateDir.resolve(relative);
                String fsDiffKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (ApplyCandidateAction.isNotAddedOrModified(fsDiffKey, fsDiff) && this.fileNotPresent(updateFile)) {
                    if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.debug("Deleting the file " + relative + " that doesn't exist in the update");
                    }
                    IoUtils.recursiveDelete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean fileNotPresent(Path updateFile) {
                return !Files.exists(updateFile, new LinkOption[0]) && !updateFile.toString().endsWith(".glnew") && !updateFile.toString().endsWith(".glold");
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.equals(skipInstallationGalleon) || dir.equals(skipInstallationInstallation) || dir.equals(ApplyCandidateAction.this.installationDir.resolve(".update.old"))) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!Files.isReadable(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (ApplyCandidateAction.isAdded(pathKey, fsDiff) && !Files.exists(target, new LinkOption[0])) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("The directory " + relative + " that doesn't exist in the update is a User changes, skipping it");
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) {
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (!ApplyCandidateAction.isAdded(pathKey, fsDiff) && !Files.exists(target, new LinkOption[0]) && ApplyCandidateAction.isEmpty(dir)) {
                        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                            ProsperoLogger.ROOT_LOGGER.debug("Deleting the directory " + relative + " that doesn't exist in the update");
                        }
                        IoUtils.recursiveDelete(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                if (exc instanceof AccessDeniedException) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(file);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    if (Files.exists(target, new LinkOption[0])) {
                        throw exc;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
                throw exc;
            }
        });
        return Collections.unmodifiableList(conflicts);
    }

    private void resolveFileConflicts(List<FileConflict> conflicts) throws IOException, ProvisioningException {
        for (FileConflict conflict : conflicts) {
            Path target = this.updateDir.resolve(conflict.getRelativePath());
            Path current = this.installationDir.resolve(conflict.getRelativePath());
            if (conflict.getUserChange() == FileConflict.Change.REMOVED && conflict.getResolution() == FileConflict.Resolution.UPDATE) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Resolving file conflict: restoring files removed by the user: " + conflict);
                }
                Files.createDirectories(current.getParent(), new FileAttribute[0]);
                IoUtils.copy(target, current);
                continue;
            }
            if (conflict.getUpdateChange() == FileConflict.Change.ADDED && conflict.getResolution() == FileConflict.Resolution.UPDATE) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Resolving file conflict: backing up user changes and applying update changes: " + conflict);
                }
                ApplyCandidateAction.glold(current, target);
                continue;
            }
            if (conflict.getUpdateChange() == FileConflict.Change.ADDED && conflict.getResolution() == FileConflict.Resolution.USER) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Resolving file conflict: preserving user changes and backing up update changes: " + conflict);
                }
                ApplyCandidateAction.glnew(target, current);
                continue;
            }
            if (conflict.getUpdateChange() == FileConflict.Change.MODIFIED && conflict.getResolution() == FileConflict.Resolution.UPDATE) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Resolving file conflict: backing up user changes and applying update changes: " + conflict);
                }
                ApplyCandidateAction.glold(current, target);
                continue;
            }
            if (conflict.getUpdateChange() == FileConflict.Change.MODIFIED && conflict.getResolution() == FileConflict.Resolution.USER) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Resolving file conflict: preserving user changes and backing up update changes: " + conflict);
                }
                ApplyCandidateAction.glnew(target, current);
                continue;
            }
            ProsperoLogger.ROOT_LOGGER.debug("Unknown conflict type: " + conflict);
        }
    }

    private static boolean isEmpty(Path dir) {
        String[] children = dir.toFile().list();
        if (children == null) {
            throw new RuntimeException("Unable to list children of " + dir);
        }
        return children.length == 0;
    }

    private static boolean isAdded(String pathKey, FsDiff fsDiff) {
        return fsDiff.getAddedEntry(pathKey) != null;
    }

    private static boolean isNotAddedOrModified(String fsDiffKey, FsDiff fsDiff) {
        return !ApplyCandidateAction.isAdded(fsDiffKey, fsDiff) && fsDiff.getModifiedEntry(fsDiffKey) == null;
    }

    private String getFsDiffKey(Path relative, boolean appendSeparator) {
        Object pathKey = relative.toString().replace(File.separator, "/");
        if (appendSeparator) {
            pathKey = ((String)pathKey).endsWith("/") ? pathKey : (String)pathKey + "/";
        }
        return pathKey;
    }

    private static void glnew(Path updateFile, Path installationFile) throws ProvisioningException {
        Path glnewFile = installationFile.getParent().resolve(installationFile.getFileName() + ".glnew");
        try {
            ApplyCandidateAction.copyFiles(updateFile, glnewFile);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + glnewFile, e);
        }
    }

    private static void glold(Path installationFile, Path target) throws ProvisioningException {
        Path gloldFile = installationFile.getParent().resolve(installationFile.getFileName() + ".glold");
        try {
            ApplyCandidateAction.copyFiles(installationFile, gloldFile);
            ApplyCandidateAction.copyFiles(target, installationFile);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + gloldFile, e);
        }
    }

    private static boolean compareContent(Path installationDir, Path updateDir) throws IOException {
        Set updateDirsPaths;
        Set instDirsPaths;
        Path instGalleonHashPath = PathsUtils.getProvisionedStateDir(installationDir).resolve("hashes");
        Path updateGalleonHashPath = PathsUtils.getProvisionedStateDir(updateDir).resolve("hashes");
        try (Stream<Path> instDirs = Files.walk(instGalleonHashPath, new FileVisitOption[0]);){
            instDirsPaths = instDirs.map(instGalleonHashPath::relativize).collect(Collectors.toUnmodifiableSet());
        }
        try (Stream<Path> instDirs = Files.walk(updateGalleonHashPath, new FileVisitOption[0]);){
            updateDirsPaths = instDirs.map(updateGalleonHashPath::relativize).collect(Collectors.toUnmodifiableSet());
        }
        if (instDirsPaths.size() != updateDirsPaths.size() || !instDirsPaths.containsAll(updateDirsPaths)) {
            return false;
        }
        for (Path path : instDirsPaths) {
            Path sourcePath = instGalleonHashPath.resolve(path);
            if (!Files.isRegularFile(sourcePath, new LinkOption[0])) continue;
            Path targetPath = updateGalleonHashPath.resolve(path);
            if (FileUtils.contentEquals(sourcePath.toFile(), targetPath.toFile())) continue;
            return false;
        }
        Path instConfPath = ProsperoMetadataUtils.configurationPath(installationDir);
        Path updatePath = ProsperoMetadataUtils.configurationPath(updateDir);
        if (!Files.exists(instConfPath, new LinkOption[0]) && Files.exists(updatePath, new LinkOption[0]) || Files.exists(instConfPath, new LinkOption[0]) && !Files.exists(updatePath, new LinkOption[0])) {
            return false;
        }
        if (Files.exists(instConfPath, new LinkOption[0]) && Files.exists(updatePath, new LinkOption[0])) {
            return FileUtils.contentEquals(instConfPath.toFile(), updatePath.toFile());
        }
        return true;
    }

    public static enum Type {
        UPDATE("UPDATE"),
        REVERT("REVERT"),
        FEATURE_ADD("FEATURE_ADD");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static Type from(String text) {
            switch (text) {
                case "UPDATE": {
                    return UPDATE;
                }
                case "REVERT": {
                    return REVERT;
                }
                case "FEATURE_ADD": {
                    return FEATURE_ADD;
                }
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidMarkerFileOperation(text);
        }
    }

    public static enum ValidationResult {
        OK,
        NOT_CANDIDATE,
        STALE,
        WRONG_TYPE,
        NO_CHANGES;

    }
}

