/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.yaml.snakeyaml.error.MarkedYAMLException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.exceptions.ApplyCandidateException;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.api.exceptions.StreamNotFoundException;
import org.wildfly.prospero.api.exceptions.UnresolvedChannelMetadataException;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.ArtifactResolutionAnalyzer;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

public class ExecutionExceptionHandler
implements CommandLine.IExecutionExceptionHandler {
    private static final Set<String> OFFLINE_REPOSITORIES = Set.of("file".split(","));
    private final CliConsole console;
    private final boolean isVerbose;

    public ExecutionExceptionHandler(CliConsole console, boolean isVerbose) {
        this.console = console;
        this.isVerbose = isVerbose;
    }

    @Override
    public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) throws Exception {
        Integer returnCode = null;
        if (ex instanceof NoChannelException) {
            this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
            this.console.error(CliMessages.MESSAGES.addChannels("--manifest"), new String[0]);
            returnCode = 2;
        }
        if (ex instanceof IllegalArgumentException) {
            this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
            returnCode = 2;
        } else if (ex instanceof ArgumentParsingException) {
            ArgumentParsingException ape = (ArgumentParsingException)ex;
            this.console.error(CliMessages.MESSAGES.errorHeader(ape.getLocalizedMessage()), new String[0]);
            for (String detail : ape.getDetails()) {
                this.console.error("  " + detail, new String[0]);
            }
            returnCode = 2;
        } else if (ex instanceof OperationException) {
            if (ex instanceof ChannelDefinitionException) {
                if (ex.getCause() != null) {
                    if (ex.getCause().getCause() instanceof SSLHandshakeException) {
                        this.console.error(CliMessages.MESSAGES.errorSSL(), new String[0]);
                    } else if (ex.getCause().getCause() instanceof UnknownHostException) {
                        this.console.error(CliMessages.MESSAGES.errorUnknownHost(), new String[0]);
                    } else {
                        this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
                    }
                }
                this.console.error(((ChannelDefinitionException)ex).getValidationMessages(), new String[0]);
            } else if (ex instanceof StreamNotFoundException) {
                StreamNotFoundException snfe = (StreamNotFoundException)ex;
                this.printResolutionException(snfe);
            } else if (ex instanceof ArtifactResolutionException) {
                ArtifactResolutionException are = (ArtifactResolutionException)ex;
                this.printResolutionException(are);
            } else if (ex instanceof UnresolvedChannelMetadataException) {
                UnresolvedChannelMetadataException mcme = (UnresolvedChannelMetadataException)ex;
                this.printMissingMetadataException(mcme);
            } else if (ex instanceof MetadataException) {
                this.console.error(ex.getLocalizedMessage(), new String[0]);
                if (ex.getCause() != null && (ex.getCause() instanceof MarkedYAMLException || ex.getCause() instanceof JsonMappingException)) {
                    this.console.error(ex.getCause().getLocalizedMessage(), new String[0]);
                }
            } else if (ex instanceof ApplyCandidateException) {
                ApplyCandidateException ace = (ApplyCandidateException)ex;
                this.console.error(System.lineSeparator() + ace.getMessage(), new String[0]);
                if (ace.isRollbackSuccessful()) {
                    this.console.error(System.lineSeparator() + CliMessages.MESSAGES.candidateApplyRollbackSuccess(), new String[0]);
                } else {
                    this.console.error(System.lineSeparator() + CliMessages.MESSAGES.candidateApplyRollbackFailure(ace.getBackupPath()), new String[0]);
                }
            } else {
                this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
            }
            returnCode = 1;
        } else if (ex instanceof ProvisioningException) {
            this.handleProvisioningException((ProvisioningException)ex);
            returnCode = 1;
        }
        if (returnCode != null) {
            if (this.isVerbose) {
                this.console.error("", new String[0]);
                ex.printStackTrace(this.console.getErrOut());
            }
            return returnCode;
        }
        throw ex;
    }

    private void handleProvisioningException(ProvisioningException ex) {
        this.console.error("\n", new String[0]);
        String message = ex.getMessage();
        if (message.startsWith("Failed to parse")) {
            String path = message.substring("Failed to parse".length() + 1).trim();
            this.console.error(CliMessages.MESSAGES.parsingError(path), new String[0]);
            if (ex.getCause() instanceof XMLStreamException) {
                this.console.error(ex.getCause().getLocalizedMessage(), new String[0]);
            }
        } else {
            this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
        }
    }

    private void printMissingMetadataException(UnresolvedChannelMetadataException ex) {
        this.console.error(CliMessages.MESSAGES.errorHeader(CliMessages.MESSAGES.unableToResolveChannelMetadata()), new String[0]);
        for (ChannelMetadataCoordinate missingArtifact : ex.getMissingArtifacts()) {
            this.console.error("  * " + ArtifactUtils.printCoordinate(missingArtifact), new String[0]);
        }
        this.printRepositories(ex.getRepositories(), ex.isOffline());
    }

    private void printResolutionException(StreamNotFoundException ex) {
        this.console.error("\n", new String[0]);
        if (!ex.getMissingArtifacts().isEmpty()) {
            this.console.error(CliMessages.MESSAGES.errorHeader(CliMessages.MESSAGES.streamsNotFound()), new String[0]);
            for (ArtifactCoordinate missingArtifact : ex.getMissingArtifacts()) {
                this.console.error("  * " + ArtifactUtils.printStream(missingArtifact), new String[0]);
            }
        } else {
            this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
        }
    }

    private void printResolutionException(ArtifactResolutionException ex) {
        this.console.error("\n", new String[0]);
        if (!ex.getMissingArtifacts().isEmpty()) {
            this.console.error(CliMessages.MESSAGES.errorHeader(CliMessages.MESSAGES.unableToResolveArtifacts()), new String[0]);
            List<ArtifactResolutionAnalyzer.Result> results = new ArtifactResolutionAnalyzer().analyze(ex);
            for (ArtifactResolutionAnalyzer.Result result : results) {
                this.console.error(String.format("  * %s [%s]", result.getCoords(), result.getStatus()), new String[0]);
            }
            this.printRepositories(ex.getRepositories(), ex.isOffline());
        } else {
            this.console.error(CliMessages.MESSAGES.errorHeader(ex.getLocalizedMessage()), new String[0]);
        }
    }

    private void printRepositories(Set<Repository> repositories, boolean b) {
        if (!repositories.isEmpty()) {
            this.console.error(" " + CliMessages.MESSAGES.attemptedRepositories(), new String[0]);
            for (Repository repository : repositories) {
                boolean isOffline = ExecutionExceptionHandler.isOffline(b, repository);
                String repo = String.format("%s::%s", repository.getId(), repository.getUrl());
                this.console.error("  *" + repo + (String)(isOffline ? " [" + CliMessages.MESSAGES.offline() + "]" : ""), new String[0]);
            }
        }
    }

    private static boolean isOffline(boolean offline, Repository repository) {
        if (!offline) {
            return false;
        }
        try {
            return !OFFLINE_REPOSITORIES.contains(new URL(repository.getUrl()).getProtocol());
        }
        catch (MalformedURLException e) {
            return true;
        }
    }
}

