/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.spi;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.spi.ProsperoInstallationManager;

public class ProsperoInstallationManagerFactory
implements InstallationManagerFactory {
    protected static final List<Path> REQUIRED_FILES = List.of(Path.of(".galleon", "provisioning.xml"), Path.of(".installation", "installer-channels.yaml"), Path.of(".installation", "manifest.yaml"));

    @Override
    public InstallationManager create(Path installationDir, MavenOptions mavenOptions) throws Exception {
        this.verifyInstallationDirectory(installationDir);
        return new ProsperoInstallationManager(installationDir, mavenOptions);
    }

    @Override
    public String getName() {
        return "prospero";
    }

    private void verifyInstallationDirectory(Path path) {
        List<Path> missingPaths = REQUIRED_FILES.stream().map(path::resolve).filter(p -> !p.toFile().isFile()).collect(Collectors.toList());
        if (!missingPaths.isEmpty()) {
            throw ProsperoLogger.ROOT_LOGGER.invalidInstallationDir(path, missingPaths);
        }
    }
}

