/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.wildfly.prospero.VersionLogger;
import org.wildfly.prospero.cli.CliConsole;
import picocli.CommandLine;

@CommandLine.Command(name="${prospero.dist.name}", resourceBundle="UsageMessages", versionProvider=VersionProvider.class)
public class MainCommand
implements Callable<Integer> {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    private final CliConsole console;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
    boolean help;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true)
    boolean version;
    @CommandLine.Option(names={"-vv", "--verbose"})
    boolean verbose;

    public MainCommand(CliConsole console) {
        this.console = console;
    }

    @Override
    public Integer call() throws IOException {
        ResourceBundle usageBundle = ResourceBundle.getBundle("UsageMessages");
        this.console.println(CommandLine.Help.Ansi.AUTO.string(usageBundle.getString("prospero.welcomeMessage")));
        this.spec.commandLine().usage(this.console.getStdOut());
        return 0;
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        @Override
        public String[] getVersion() throws Exception {
            return new String[]{VersionLogger.getVersion()};
        }
    }
}

