/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.promotion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.eclipse.aether.artifact.Artifact;
import org.wildfly.channel.ArtifactCoordinate;

public class CustomArtifact {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String extension;

    @JsonCreator
    public CustomArtifact(@JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="classifier") String classifier, @JsonProperty(value="extension") String extension, @JsonProperty(value="version") String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension == null ? "jar" : extension;
    }

    public static CustomArtifact from(Artifact a) {
        return new CustomArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getVersion());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    @JsonIgnore
    public ArtifactCoordinate toCoordinate() {
        return new ArtifactCoordinate(this.groupId, this.artifactId, this.extension, this.classifier, this.version);
    }
}

