/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import picocli.CommandLine;

public class CustomHelp
extends CommandLine.Help {
    private final CommandLine.Model.CommandSpec commandSpec;

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    public CustomHelp(CommandLine.Model.CommandSpec commandSpec, CommandLine.Help.ColorScheme colorScheme) {
        super(commandSpec, colorScheme);
        this.commandSpec = commandSpec;
    }

    @Override
    public String synopsis(int synopsisHeadingLength) {
        if (!CustomHelp.empty(this.commandSpec.usageMessage().customSynopsis())) {
            return this.customSynopsis(new Object[0]);
        }
        return this.commandSpec.usageMessage().abbreviateSynopsis() ? this.abbreviatedSynopsis() : this.detailedSynopsis(synopsisHeadingLength, this.createDefaultOptionSort(), false);
    }

    @Override
    protected String makeSynopsisFromParts(int synopsisHeadingLength, CommandLine.Help.Ansi.Text optionText, CommandLine.Help.Ansi.Text groupsText, CommandLine.Help.Ansi.Text endOfOptionsText, CommandLine.Help.Ansi.Text positionalParamText, CommandLine.Help.Ansi.Text commandText) {
        boolean positionalsOnly = true;
        for (CommandLine.Model.ArgGroupSpec group : this.commandSpec().argGroups()) {
            if (!group.validate()) continue;
            positionalsOnly &= group.allOptionsNested().isEmpty();
        }
        CommandLine.Help.Ansi.Text text = positionalsOnly ? optionText.concat(endOfOptionsText).concat(groupsText).concat(positionalParamText).concat(commandText) : groupsText.concat(optionText).concat(endOfOptionsText).concat(positionalParamText).concat(commandText);
        return this.insertSynopsisCommandName(synopsisHeadingLength, text);
    }

    public static class CustomHelpFactory
    implements CommandLine.IHelpFactory {
        @Override
        public CommandLine.Help create(CommandLine.Model.CommandSpec commandSpec, CommandLine.Help.ColorScheme colorScheme) {
            return new CustomHelp(commandSpec, colorScheme);
        }
    }
}

