/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.channel;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="initialize", aliases={"init"}, sortOptions=false, hidden=true)
public class ChannelInitializeCommand
extends AbstractCommand {
    public static final String CUSTOMIZATION_REPO_ID = "customization-repository";
    public static final String CUSTOM_CHANNELS_GROUP_ID = "custom.channels";
    public static final String DEFAULT_CUSTOMIZATION_REPOSITORY = "customization-repository";
    @CommandLine.Option(names={"--manifest"})
    private Optional<String> manifestName;
    @CommandLine.Option(names={"--repository-url"}, descriptionKey="customization-repository")
    private Optional<URL> repositoryUrl;
    @CommandLine.Option(names={"--dir"})
    Optional<Path> directory;

    public ChannelInitializeCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Path installationDirectory = ChannelInitializeCommand.determineInstallationDirectory(this.directory);
        try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
            Comparable<Path> defaultLocalRepoPath;
            URL url;
            if (!this.validateRepository(metadataAction) || !this.validateChannel()) {
                Integer n = 2;
                return n;
            }
            if (this.repositoryUrl.isPresent()) {
                url = this.repositoryUrl.get();
                if (this.repositoryUrl.get().getProtocol().equals("file") && !this.createLocalRepository(Paths.get(this.repositoryUrl.get().toURI()))) {
                    Integer n = 1;
                    return n;
                }
            } else {
                defaultLocalRepoPath = installationDirectory.resolve(".installation").resolve("customization-repository");
                if (!this.createLocalRepository((Path)defaultLocalRepoPath)) {
                    Integer n = 1;
                    return n;
                }
                url = defaultLocalRepoPath.toUri().toURL();
            }
            if (this.manifestName.isEmpty()) {
                if (this.customizationChannelExists(metadataAction)) {
                    this.console.error(CliMessages.MESSAGES.customizationChannelAlreadyExists(), new String[0]);
                    defaultLocalRepoPath = 1;
                    return defaultLocalRepoPath;
                }
                this.manifestName = Optional.of("custom.channels:" + RandomStringUtils.randomAlphanumeric((int)8));
            }
            this.console.println(CliMessages.MESSAGES.registeringCustomChannel(this.manifestName.get()));
            Channel channel = new Channel("customization", null, null, List.of(new Repository("customization-repository", url.toExternalForm())), ArtifactUtils.manifestCoordFromString((String)this.manifestName.get()), null, null);
            metadataAction.addChannel(channel);
        }
        return 0;
    }

    private boolean customizationChannelExists(MetadataAction metadataAction) throws MetadataException {
        return metadataAction.getChannels().stream().map(Channel::getManifestCoordinate).anyMatch(m -> m.getMaven() != null && m.getMaven().getGroupId().equals(CUSTOM_CHANNELS_GROUP_ID));
    }

    private boolean createLocalRepository(Path localRepository) throws URISyntaxException {
        File file = localRepository.toFile();
        if (!this.isWritable(file)) {
            this.console.error(CliMessages.MESSAGES.unableToCreateLocalRepository(localRepository), new String[0]);
            return false;
        }
        if (file.exists() && !Files.isDirectory(file.toPath(), new LinkOption[0])) {
            this.console.error(CliMessages.MESSAGES.repositoryIsNotDirectory(localRepository).getMessage(), new String[0]);
            return false;
        }
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.console.error(CliMessages.MESSAGES.unableToCreateLocalRepository(localRepository), new String[0]);
                this.console.error(e.getLocalizedMessage(), new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean isWritable(File file) {
        if (file.exists()) {
            return Files.isWritable(file.toPath());
        }
        if (file.getParentFile() == null) {
            return false;
        }
        return this.isWritable(file.getParentFile());
    }

    private boolean validateChannel() {
        if (this.manifestName.isEmpty()) {
            return true;
        }
        try {
            ChannelManifestCoordinate manifestRef = ArtifactUtils.manifestCoordFromString((String)this.manifestName.get());
            if (manifestRef.getMaven() == null) {
                this.console.error(CliMessages.MESSAGES.illegalChannel(this.manifestName.get()), new String[0]);
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.console.error(CliMessages.MESSAGES.illegalChannel(this.manifestName.get()), new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateRepository(MetadataAction metadataAction) throws MetadataException {
        if (metadataAction.getChannels().stream().flatMap(c -> c.getRepositories().stream()).anyMatch(r -> r.getId().equals("customization-repository"))) {
            this.console.error(CliMessages.MESSAGES.customizationRepoExist("customization-repository"), new String[0]);
            return false;
        }
        return true;
    }
}

