/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.channel.Channel;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.proxy.HttpProxy;

public class ChannelMapper {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    public static final String SCHEMA_VERSION_2_0_0 = "2.0.0";
    public static final String CURRENT_SCHEMA_VERSION = "2.0.0";
    private static final String SCHEMA_1_0_0_FILE = "org/wildfly/channel/v1.0.0/schema.json";
    private static final String SCHEMA_2_0_0_FILE = "org/wildfly/channel/v2.0.0/schema.json";
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory().configure(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR, true);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(YAML_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.builder(JsonSchemaFactory.getInstance(SpecVersion.VersionFlag.V201909)).objectMapper(OBJECT_MAPPER).build();
    private static final Map<String, JsonSchema> SCHEMAS = new HashMap<String, JsonSchema>();

    private static JsonSchema getSchema(JsonNode node) {
        JsonNode schemaVersion = node.path("schemaVersion");
        String version = schemaVersion.asText();
        if (version == null || version.isEmpty()) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("The manifest does not specify a schemaVersion."));
        }
        JsonSchema schema = SCHEMAS.get(version);
        if (schema == null) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("Unknown schema version " + schemaVersion));
        }
        return schema;
    }

    public static String toYaml(Channel ... channels) throws IOException {
        return ChannelMapper.toYaml(Arrays.asList(channels));
    }

    public static String toYaml(List<Channel> channels) throws IOException {
        Objects.requireNonNull(channels);
        StringWriter w = new StringWriter();
        for (Channel channel : channels) {
            OBJECT_MAPPER.writeValue(w, (Object)channel);
        }
        return w.toString();
    }

    public static Channel from(URL channelURL) throws InvalidChannelMetadataException {
        Objects.requireNonNull(channelURL);
        try {
            List<String> messages;
            if (channelURL.toString().endsWith("/")) {
                channelURL = channelURL.toURI().resolve("channel.yaml").toURL();
            }
            if (!(messages = ChannelMapper.validate(channelURL)).isEmpty()) {
                throw new InvalidChannelMetadataException("Invalid channel", messages);
            }
            return OBJECT_MAPPER.readValue(channelURL, Channel.class);
        }
        catch (IOException | URISyntaxException e) {
            throw ChannelMapper.wrapException(e);
        }
    }

    public static List<Channel> fromString(String yamlContent) throws InvalidChannelMetadataException {
        Objects.requireNonNull(yamlContent);
        try {
            List<String> messages = ChannelMapper.validateString(yamlContent);
            if (!messages.isEmpty()) {
                throw new InvalidChannelMetadataException("Invalid channel", messages);
            }
            YAMLParser parser = YAML_FACTORY.createParser(yamlContent);
            return ((MappingIterator)OBJECT_MAPPER.readValues((JsonParser)parser, Channel.class)).readAll();
        }
        catch (IOException e) {
            throw ChannelMapper.wrapException(e);
        }
    }

    private static List<String> validate(URL url) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(url);
        JsonSchema schema = ChannelMapper.getSchema(node);
        Set<ValidationMessage> validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static List<String> validateString(String yamlContent) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(yamlContent);
        JsonSchema schema = ChannelMapper.getSchema(node);
        Set<ValidationMessage> validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static InvalidChannelMetadataException wrapException(Exception e) {
        InvalidChannelMetadataException ice = new InvalidChannelMetadataException("Invalid Channel", Collections.singletonList(e.getLocalizedMessage()));
        ice.initCause(e);
        return ice;
    }

    static {
        HttpProxy.setup();
        SCHEMAS.put(SCHEMA_VERSION_1_0_0, SCHEMA_FACTORY.getSchema(ChannelMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_0_0_FILE)));
        SCHEMAS.put("2.0.0", SCHEMA_FACTORY.getSchema(ChannelMapper.class.getClassLoader().getResourceAsStream(SCHEMA_2_0_0_FILE)));
    }
}

