/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.spi;

import java.nio.file.Path;
import org.wildfly.installationmanager.spi.OsShell;
import org.wildfly.prospero.cli.DistributionInfo;
import org.wildfly.prospero.spi.internal.CliProvider;

public class CliProviderImpl
implements CliProvider {
    public String getScriptName(OsShell shell) {
        String suffix;
        switch (shell) {
            case Linux: {
                suffix = ".sh";
                break;
            }
            case WindowsBash: {
                suffix = ".bat";
                break;
            }
            case WindowsPowerShell: {
                suffix = ".ps1";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The requested shell %s is not supported", shell));
            }
        }
        return DistributionInfo.DIST_NAME + suffix;
    }

    public String getApplyUpdateCommand(Path installationPath, Path candidatePath) {
        return "update apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes";
    }

    public String getApplyRevertCommand(Path installationPath, Path candidatePath) {
        return "revert apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes";
    }

    private String escape(Path absolutePath) {
        return "\"" + absolutePath.toString() + "\"";
    }
}

