/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonFeaturePackAnalyzer;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.metadata.ManifestVersionResolver;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.MarkerFile;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

class PrepareCandidateAction
implements AutoCloseable {
    private final InstallationMetadata metadata;
    private final ProsperoConfig prosperoConfig;
    private final MavenSessionManager mavenSessionManager;

    PrepareCandidateAction(Path installDir, MavenSessionManager mavenSessionManager, ProsperoConfig prosperoConfig) throws OperationException {
        this.metadata = InstallationMetadata.loadInstallation(installDir);
        this.prosperoConfig = prosperoConfig;
        this.mavenSessionManager = mavenSessionManager;
    }

    boolean buildCandidate(Path targetDir, GalleonEnvironment galleonEnv, ApplyCandidateAction.Type operation, ProvisioningConfig config) throws ProvisioningException, OperationException {
        this.doBuildUpdate(targetDir, galleonEnv, config);
        try {
            SavedState savedState = this.metadata.getRevisions().get(0);
            new MarkerFile(savedState.getName(), operation).write(targetDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void doBuildUpdate(Path targetDir, GalleonEnvironment galleonEnv, ProvisioningConfig provisioningConfig) throws ProvisioningException, OperationException {
        ProvisioningManager provMgr = galleonEnv.getProvisioningManager();
        try {
            GalleonUtils.executeGalleon(options -> {
                options.put("export-system-paths", "true");
                provMgr.provision(provisioningConfig, (Map<String, String>)options);
            }, this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
        }
        try {
            ManifestVersionRecord manifestRecord = new ManifestVersionResolver(this.mavenSessionManager.getProvisioningRepo(), this.mavenSessionManager.newRepositorySystem()).getCurrentVersions(galleonEnv.getChannels());
            this.writeProsperoMetadata(targetDir, galleonEnv.getRepositoryManager(), this.prosperoConfig.getChannels(), manifestRecord);
        }
        catch (IOException ex) {
            throw ProsperoLogger.ROOT_LOGGER.unableToDownloadFile(ex);
        }
        try {
            GalleonFeaturePackAnalyzer galleonFeaturePackAnalyzer = new GalleonFeaturePackAnalyzer(galleonEnv.getChannels(), this.mavenSessionManager);
            galleonFeaturePackAnalyzer.cacheGalleonArtifacts(targetDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private void writeProsperoMetadata(Path home, ChannelMavenArtifactRepositoryManager maven, List<Channel> channels, ManifestVersionRecord manifestVersions) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(home, manifest, new ProsperoConfig(channels), Optional.of(manifestVersions));){
            installationMetadata.recordProvision(true, false);
        }
    }
}

