/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import org.wildfly.prospero.wfchannel.MavenSessionManager;
import picocli.CommandLine;

public abstract class AbstractInstallCommand
extends AbstractCommand {
    @CommandLine.ArgGroup(heading="%nInstallation source:%n", exclusive=true, multiplicity="1", order=1)
    InstallCommand.FeaturePackOrDefinition featurePackOrDefinition;
    @CommandLine.Option(names={"--channels", "--channel"}, paramLabel="<channel-reference>", order=2, split=",")
    List<String> channelCoordinates = new ArrayList<String>();
    @CommandLine.Option(names={"--manifest"}, paramLabel="<manifest-reference>", order=3)
    Optional<String> manifestCoordinate;
    @CommandLine.Option(names={"--repositories"}, paramLabel="<repo-url>", split=",", order=4)
    List<String> remoteRepositories = new ArrayList<String>();
    @CommandLine.ArgGroup(exclusive=true, order=5, headingKey="localRepoOptions.heading")
    LocalRepoOptions localRepoOptions = new LocalRepoOptions();
    @CommandLine.Option(names={"--offline"}, order=6)
    Optional<Boolean> offline = Optional.empty();

    public AbstractInstallCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    protected List<Channel> resolveChannels(ProvisioningDefinition provisioningDefinition, MavenOptions mavenOptions) throws ArgumentParsingException, ProvisioningException, NoChannelException, ChannelDefinitionException {
        MavenSessionManager mavenSessionManager = new MavenSessionManager(mavenOptions);
        VersionResolverFactory versionResolverFactory = InstallCommand.createVersionResolverFactory(mavenSessionManager);
        List<Channel> channels = provisioningDefinition.resolveChannels(versionResolverFactory);
        return channels;
    }

    protected MavenOptions getMavenOptions() throws ArgumentParsingException {
        MavenOptions.Builder mavenOptions = this.localRepoOptions.toOptions();
        this.offline.map(mavenOptions::setOffline);
        return mavenOptions.build();
    }

    protected ProvisioningDefinition buildDefinition() throws MetadataException, NoChannelException, ArgumentParsingException {
        ProvisioningDefinition provisioningDefinition = ProvisioningDefinition.builder().setFpl(this.featurePackOrDefinition.fpl.orElse(null)).setProfile(this.featurePackOrDefinition.profile.orElse(null)).setManifest(this.manifestCoordinate.orElse(null)).setChannelCoordinates(this.channelCoordinates).setOverrideRepositories(RepositoryDefinition.from(this.remoteRepositories)).setDefinitionFile(this.featurePackOrDefinition.definition.map(Path::toUri).orElse(null)).build();
        return provisioningDefinition;
    }

    protected static VersionResolverFactory createVersionResolverFactory(MavenSessionManager mavenSessionManager) {
        RepositorySystem repositorySystem = mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession repositorySystemSession = mavenSessionManager.newRepositorySystemSession(repositorySystem);
        return new VersionResolverFactory(repositorySystem, repositorySystemSession);
    }
}

