/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.metadata;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.LocalRepository;
import org.jboss.galleon.util.HashUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.prospero.metadata.ManifestVersionRecord;

public class ManifestVersionResolver {
    private static final Logger LOG = Logger.getLogger(ManifestVersionResolver.class.getName());
    private final VersionResolverFactory resolverFactory;

    public ManifestVersionResolver(Path localMavenCache, RepositorySystem system) {
        Objects.requireNonNull(localMavenCache);
        Objects.requireNonNull(system);
        DefaultRepositorySystemSession session = ManifestVersionResolver.newRepositorySystemSession(system, localMavenCache);
        this.resolverFactory = new VersionResolverFactory(system, session);
    }

    ManifestVersionResolver(VersionResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
    }

    public ManifestVersionRecord getCurrentVersions(List<Channel> channels) throws IOException {
        Objects.requireNonNull(channels);
        ManifestVersionRecord manifestVersionRecord = new ManifestVersionRecord();
        for (Channel channel : channels) {
            ChannelManifestCoordinate manifestCoordinate = channel.getManifestCoordinate();
            if (manifestCoordinate == null) {
                List<String> repos = channel.getRepositories().stream().map(Repository::getId).collect(Collectors.toList());
                manifestVersionRecord.addManifest(new ManifestVersionRecord.NoManifest(repos, channel.getNoStreamStrategy().toString()));
                continue;
            }
            if (manifestCoordinate.getUrl() != null) {
                String content = this.read(manifestCoordinate.getUrl());
                String hashCode = HashUtils.hash(content);
                ChannelManifest manifest = ChannelManifestMapper.from(manifestCoordinate.getUrl());
                manifestVersionRecord.addManifest(new ManifestVersionRecord.UrlManifest(manifestCoordinate.getUrl().toExternalForm(), hashCode, manifest.getName()));
                continue;
            }
            if (manifestCoordinate.getVersion() != null) {
                String description = this.getManifestDescription(manifestCoordinate, this.resolverFactory.create((Collection<Repository>)channel.getRepositories()));
                manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getVersion(), description));
                continue;
            }
            MavenVersionsResolver mavenVersionsResolver = this.resolverFactory.create((Collection<Repository>)channel.getRepositories());
            Optional<String> latestVersion = VersionMatcher.getLatestVersion(mavenVersionsResolver.getAllVersions(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), manifestCoordinate.getExtension(), manifestCoordinate.getClassifier()));
            if (latestVersion.isPresent()) {
                String description = this.getManifestDescription(new ChannelManifestCoordinate(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), latestVersion.get()), mavenVersionsResolver);
                manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), latestVersion.get(), description));
                continue;
            }
            LOG.warn("Unable to determine version of manifest used: " + manifestCoordinate);
            manifestVersionRecord.addManifest(new ManifestVersionRecord.MavenManifest(manifestCoordinate.getGroupId(), manifestCoordinate.getArtifactId(), "", null));
        }
        return manifestVersionRecord;
    }

    private String getManifestDescription(ChannelManifestCoordinate manifestCoordinate, MavenVersionsResolver mavenVersionsResolver) {
        String description;
        List<URL> urls = mavenVersionsResolver.resolveChannelMetadata(List.of(manifestCoordinate));
        if (!urls.isEmpty()) {
            ChannelManifest manifest = ChannelManifestMapper.from(urls.get(0));
            description = manifest.getName();
        } else {
            description = null;
        }
        return description;
    }

    private String read(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                inputStream.transferTo(outputStream);
                string = ((Object)outputStream).toString();
            }
            return string;
        }
    }

    private static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, Path localMavenCache) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localMavenCache.toFile());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, localRepo));
        session.setOffline(true);
        return session;
    }
}

