/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class InstallationRestoreAction {
    private final Path installDir;
    private final Console console;
    private final MavenSessionManager mavenSessionManager;

    public InstallationRestoreAction(Path installDir, MavenOptions mavenOptions, Console console) throws ProvisioningException {
        this.installDir = installDir;
        this.mavenSessionManager = new MavenSessionManager(mavenOptions);
        this.console = console;
    }

    public void restore(Path metadataBundleZip, List<Repository> remoteRepositories) throws ProvisioningException, IOException, OperationException {
        if (this.installDir.toFile().exists()) {
            throw ProsperoLogger.ROOT_LOGGER.installationDirAlreadyExists(this.installDir);
        }
        try (InstallationMetadata metadataBundle = InstallationMetadata.fromMetadataBundle(metadataBundleZip);){
            ProsperoConfig prosperoConfig = metadataBundle.getProsperoConfig();
            ArrayList<Channel> originalChannels = new ArrayList<Channel>(prosperoConfig.getChannels());
            if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
                prosperoConfig.getChannels().clear();
                prosperoConfig.getChannels().addAll(TemporaryRepositoriesHandler.overrideRepositories(originalChannels, remoteRepositories));
            }
            try (GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installDir, prosperoConfig.getChannels(), this.mavenSessionManager).setConsole(this.console).setRestoreManifest(metadataBundle.getManifest()).build();){
                GalleonUtils.executeGalleon(options -> galleonEnv.getProvisioningManager().provision(metadataBundle.getGalleonProvisioningConfig(), (Map<String, String>)options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
                this.writeProsperoMetadata(galleonEnv.getChannelSession().getRecordedChannel(), originalChannels);
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new ArtifactResolutionException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, e.getUnresolvedArtifacts(), e.getAttemptedRepositories(), this.mavenSessionManager.isOffline());
            }
        }
    }

    private void writeProsperoMetadata(ChannelManifest manifest, List<Channel> channels) throws MetadataException {
        try (InstallationMetadata installationMetadata = InstallationMetadata.newInstallation(this.installDir, manifest, new ProsperoConfig(channels), Optional.empty());){
            installationMetadata.recordProvision(true, true);
        }
    }
}

