/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.printers.ChannelPrinter;
import picocli.CommandLine;

@CommandLine.Command(name="channel")
public class ChannelCommand
extends AbstractCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;

    public ChannelCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() {
        this.spec.commandLine().usage(this.console.getErrOut());
        return 2;
    }

    @CommandLine.Command(name="list")
    public static class ChannelListCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"})
        Optional<Path> directory;

        public ChannelListCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            List<Channel> channels;
            Path installationDirectory = ChannelListCommand.determineInstallationDirectory(this.directory);
            this.console.println(CliMessages.MESSAGES.listChannels(installationDirectory));
            try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
                channels = metadataAction.getChannels();
            }
            ChannelPrinter channelPrinter = new ChannelPrinter(this.console);
            this.console.println("-------");
            for (Channel channel : channels) {
                channelPrinter.print(channel);
                this.console.println("-------");
            }
            return 0;
        }
    }
}

