/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.galleon.ArtifactCache;

public class CachedVersionResolver
implements MavenVersionsResolver {
    private final MavenVersionsResolver fallbackResolver;
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final ArtifactCache artifactCache;
    private final Logger log = Logger.getLogger(CachedVersionResolver.class);

    public CachedVersionResolver(MavenVersionsResolver fallbackResolver, ArtifactCache cache, RepositorySystem system, RepositorySystemSession session) {
        this.fallbackResolver = fallbackResolver;
        this.system = system;
        this.session = session;
        this.artifactCache = cache;
    }

    @Override
    public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
        return this.fallbackResolver.getAllVersions(groupId, artifactId, extension, classifier);
    }

    @Override
    public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Optional<File> path = this.artifactCache.getArtifact(groupId, artifactId, extension, classifier, version);
        if (path.isEmpty()) {
            return this.fallbackResolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
        }
        if (this.installArtifactLocally(groupId, artifactId, extension, classifier, version, path.get())) {
            return path.get();
        }
        return this.fallbackResolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
    }

    @Override
    public List<File> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
        ArrayList<Function<List, File>> res = new ArrayList<Function<List, File>>(coordinates.size());
        ArrayList<ArtifactCoordinate> missingArtifacts = new ArrayList<ArtifactCoordinate>();
        int index = 0;
        for (ArtifactCoordinate coordinate : coordinates) {
            int i;
            Optional<File> path = this.artifactCache.getArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getExtension(), coordinate.getClassifier(), coordinate.getVersion());
            if (path.isEmpty()) {
                i = index++;
                res.add(list -> (File)list.get(i));
                missingArtifacts.add(coordinate);
                continue;
            }
            if (this.installArtifactLocally(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getExtension(), coordinate.getClassifier(), coordinate.getVersion(), path.get())) {
                res.add(list -> (File)path.get());
                continue;
            }
            i = index++;
            res.add(list -> (File)list.get(i));
            missingArtifacts.add(coordinate);
        }
        List<File> resolvedFromMaven = this.fallbackResolver.resolveArtifacts(missingArtifacts);
        return res.stream().map(f -> (File)f.apply(resolvedFromMaven)).collect(Collectors.toList());
    }

    @Override
    public List<URL> resolveChannelMetadata(List<? extends ChannelMetadataCoordinate> manifestCoords) throws UnresolvedMavenArtifactException {
        return this.fallbackResolver.resolveChannelMetadata(manifestCoords);
    }

    @Override
    public String getMetadataReleaseVersion(String groupId, String artifactId) {
        return this.fallbackResolver.getMetadataReleaseVersion(groupId, artifactId);
    }

    @Override
    public String getMetadataLatestVersion(String groupId, String artifactId) {
        return this.fallbackResolver.getMetadataLatestVersion(groupId, artifactId);
    }

    private boolean installArtifactLocally(String groupId, String artifactId, String extension, String classifier, String version, File path) {
        try {
            InstallRequest request = new InstallRequest();
            request.setArtifacts(List.of(new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, path)));
            this.system.install(this.session, request);
            return true;
        }
        catch (InstallationException e) {
            this.log.debug((Object)"Unable to install cached artifact into LRM, falling back to resolver.", e);
            return false;
        }
    }
}

