/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.ChannelResolvable;
import org.wildfly.prospero.galleon.MavenArtifactMapper;

public class MavenArtifactDirectResolverRepositoryManager
implements MavenRepoManager,
ChannelResolvable {
    private final ChannelSession channelSession;

    public MavenArtifactDirectResolverRepositoryManager(ChannelSession channelSession) {
        this.channelSession = channelSession;
    }

    @Override
    public void resolve(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        MavenArtifact result;
        this.checkArtifact(artifact);
        try {
            result = this.channelSession.resolveDirectMavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getVersion());
        }
        catch (UnresolvedMavenArtifactException ex) {
            throw new MavenUniverseException(ex.getLocalizedMessage(), ex);
        }
        MavenArtifactMapper.resolve(artifact, result);
    }

    private void checkArtifact(org.jboss.galleon.universe.maven.MavenArtifact artifact) {
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Version of " + String.valueOf(artifact) + " is null");
        }
    }

    @Override
    public void resolveAll(Collection<org.jboss.galleon.universe.maven.MavenArtifact> artifacts) throws MavenUniverseException {
        artifacts.forEach(this::checkArtifact);
        MavenArtifactMapper mapper = new MavenArtifactMapper(artifacts);
        List<MavenArtifact> channelArtifacts = this.channelSession.resolveDirectMavenArtifacts(mapper.toChannelArtifacts());
        mapper.applyResolution(channelArtifacts);
    }

    @Override
    public boolean isResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean isLatestVersionResolved(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void resolveLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, boolean locallyAvailable) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getLatestVersion(org.jboss.galleon.universe.maven.MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public List<String> getAllVersions(org.jboss.galleon.universe.maven.MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void install(org.jboss.galleon.universe.maven.MavenArtifact artifact, Path path) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

