/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.proxy;

import java.net.URL;
import org.apache.http.HttpHost;
import org.jboss.logging.Logger;
import org.wildfly.channel.proxy.HttpUrlStreamHandlerFactory;
import org.wildfly.channel.proxy.SettingsFactory;

public abstract class HttpProxy {
    private static final Logger LOG = Logger.getLogger(HttpProxy.class);
    static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    static final String HTTP_PROXY_HOST = "http.proxyHost";
    static final String HTTP_PROXY_PORT = "http.proxyPort";
    static final String HTTP_PROXY_USERNAME = "http.proxyUser";
    static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    static final String HTTP_PROXY_PROTOCOL = "http.proxyProtocol";
    static final String HTTPS_PROXY_HOST = "https.proxyHost";
    static final String HTTPS_PROXY_PORT = "https.proxyPort";
    static final String HTTPS_PROXY_USERNAME = "https.proxyUser";
    static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    static final String HTTPS_PROXY_PROTOCOL = "https.proxyProtocol";

    private HttpProxy() {
    }

    public static void setup() {
        try {
            URL.setURLStreamHandlerFactory(new HttpUrlStreamHandlerFactory());
        }
        catch (Error error) {
            LOG.warn((Object)"Unable to URL.setURLStreamHandlerFactory", error);
        }
    }

    static void cleanupSystemProperties() {
        for (SettingsFactory factory : SettingsFactory.values()) {
            factory.cleanupProperties(System.getProperties());
        }
    }

    static HttpHost asHttpHost(URL url) {
        int port = url.getPort();
        if (port <= 0) {
            port = url.getDefaultPort();
        }
        HttpHost host = new HttpHost(url.getHost(), port, url.getProtocol());
        return host;
    }
}

