/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.util.Arrays;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.DistributionInfo;
import org.wildfly.prospero.cli.ExecutionExceptionHandler;
import org.wildfly.prospero.cli.UnknownCommandParameterExceptionHandler;
import org.wildfly.prospero.cli.commands.ChannelCommand;
import org.wildfly.prospero.cli.commands.CloneCommand;
import org.wildfly.prospero.cli.commands.CompletionCommand;
import org.wildfly.prospero.cli.commands.FeaturesCommand;
import org.wildfly.prospero.cli.commands.HistoryCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.MainCommand;
import org.wildfly.prospero.cli.commands.PrintLicensesCommand;
import org.wildfly.prospero.cli.commands.RevertCommand;
import org.wildfly.prospero.cli.commands.UpdateCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelAddCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelInitializeCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelPromoteCommand;
import org.wildfly.prospero.cli.commands.channel.ChannelRemoveCommand;
import picocli.CommandLine;

public class CliMain {
    static final org.jboss.logging.Logger logger;

    private static void enableJBossLogManager() {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        }
    }

    public static void main(String[] args) {
        try {
            int exitCode = CliMain.execute(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            CliMain.logException(e);
            System.exit(1);
        }
    }

    public static CommandLine createCommandLine(CliConsole console, String[] args) {
        return CliMain.createCommandLine(console, args, new ActionFactory());
    }

    public static CommandLine createCommandLine(CliConsole console, String[] args, ActionFactory actionFactory) {
        CommandLine commandLine = new CommandLine(new MainCommand(console));
        commandLine.setCommandName(DistributionInfo.DIST_NAME);
        commandLine.addSubcommand(new InstallCommand(console, actionFactory));
        UpdateCommand updateCommand = new UpdateCommand(console, actionFactory);
        commandLine.addSubcommand(updateCommand);
        updateCommand.addSubCommands(commandLine);
        commandLine.addSubcommand(new PrintLicensesCommand(console, actionFactory));
        commandLine.addSubcommand(new HistoryCommand(console, actionFactory));
        RevertCommand revertCommand = new RevertCommand(console, actionFactory);
        commandLine.addSubcommand(revertCommand);
        revertCommand.addSubCommands(commandLine);
        commandLine.addSubcommand(new ChannelCommand(console, actionFactory));
        commandLine.addSubcommand(new CompletionCommand());
        CommandLine channelCmd = commandLine.getSubcommands().get("channel");
        channelCmd.addSubcommand(new ChannelAddCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelRemoveCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelCommand.ChannelListCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelCommand.ChannelVersionCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelInitializeCommand(console, actionFactory));
        channelCmd.addSubcommand(new ChannelPromoteCommand(console, actionFactory));
        CloneCommand cloneCommand = new CloneCommand(console, actionFactory);
        commandLine.addSubcommand(cloneCommand);
        cloneCommand.addSubCommands(commandLine);
        FeaturesCommand featuresCommand = new FeaturesCommand(console, actionFactory);
        commandLine.addSubcommand(featuresCommand);
        featuresCommand.addSubCommands(commandLine);
        commandLine.setUsageHelpAutoWidth(true);
        boolean isVerbose = Arrays.stream(args).anyMatch(s -> s.equals("-vv") || s.equals("--verbose"));
        CommandLine.IParameterExceptionHandler rootParameterExceptionHandler = commandLine.getParameterExceptionHandler();
        commandLine.setExecutionExceptionHandler(new ExecutionExceptionHandler(console, isVerbose));
        commandLine.setParameterExceptionHandler(new UnknownCommandParameterExceptionHandler(rootParameterExceptionHandler, System.err));
        boolean isDebug = Arrays.stream(args).anyMatch("--debug"::equals);
        if (isDebug) {
            Configurator c = Logger.getLogger("").getAttachment(Configurator.ATTACHMENT_KEY);
            if (c instanceof PropertyConfigurator) {
                LogContextConfiguration lcc = ((PropertyConfigurator)c).getLogContextConfiguration();
                lcc.getLoggerConfiguration("org.wildfly.prospero").setLevel(Level.DEBUG.getName());
                lcc.getLoggerConfiguration("org.wildfly.prospero").addHandlerName("CONSOLE");
                lcc.getHandlerConfiguration("CONSOLE").setLevel(Level.DEBUG.getName());
                lcc.commit();
            } else {
                logger.warn("Cannot change logging level, using default.");
            }
        }
        return commandLine;
    }

    static int execute(String[] args) {
        CliConsole console = new CliConsole();
        CommandLine commandLine = CliMain.createCommandLine(console, args);
        return commandLine.execute(args);
    }

    static void logException(Exception e) {
        System.err.println(CliMessages.MESSAGES.errorWhenProcessingCommand() + e.getMessage());
        logger.error((Object)CliMessages.MESSAGES.errorWhenProcessingCommand(), e);
    }

    static {
        CliMain.enableJBossLogManager();
        logger = org.jboss.logging.Logger.getLogger(CliMain.class);
    }
}

