/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    protected final CliConsole console;
    protected final ActionFactory actionFactory;
    private static final Logger log = Logger.getLogger(AbstractCommand.class);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, order=100)
    boolean help;
    @CommandLine.Option(names={"-vv", "--verbose"}, order=101)
    boolean verbose;
    @CommandLine.Option(names={"--debug"}, order=102)
    boolean debug;

    public AbstractCommand(CliConsole console, ActionFactory actionFactory) {
        this.console = console;
        this.actionFactory = actionFactory;
    }

    protected static Path determineInstallationDirectory(Optional<Path> directoryOption) throws ArgumentParsingException {
        return AbstractCommand.determineInstallationDirectory(directoryOption, AbstractCommand.currentDir());
    }

    static Path determineInstallationDirectory(Optional<Path> directoryOption, Path currentDir) throws ArgumentParsingException {
        Path installationDirectory = directoryOption.orElse(currentDir).toAbsolutePath();
        if (directoryOption.isPresent()) {
            if (!AbstractCommand.verifyDirectoryContainsInstallation(installationDirectory)) {
                throw CliMessages.MESSAGES.invalidInstallationDir(installationDirectory);
            }
        } else {
            while (!AbstractCommand.verifyDirectoryContainsInstallation(installationDirectory)) {
                if ((installationDirectory = installationDirectory.getParent()) != null) continue;
                throw CliMessages.MESSAGES.invalidInstallationDirMaybeUseDirOption(AbstractCommand.currentDir().toAbsolutePath());
            }
        }
        return installationDirectory;
    }

    static boolean verifyDirectoryContainsInstallation(Path path) {
        Path dotGalleonDir = path.resolve(".galleon");
        Path channelsFile = path.resolve(".installation").resolve("installer-channels.yaml");
        return Files.isDirectory(dotGalleonDir, new LinkOption[0]) && Files.isRegularFile(channelsFile, new LinkOption[0]);
    }

    static Path currentDir() {
        return Paths.get(".", new String[0]).toAbsolutePath();
    }

    protected static void verifyTargetDirectoryIsEmpty(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                log.debug((Object)"Target is not a directory");
                throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
            }
            if (path.toFile().list().length != 0) {
                log.debug((Object)"Target folder is not empty");
                throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
            }
        }
        if (!AbstractCommand.isWritable(path)) {
            log.debug((Object)"Target is not writable");
            throw CliMessages.MESSAGES.nonEmptyTargetFolder(path);
        }
    }

    private static boolean isWritable(Path path) {
        Path absPath = path.toAbsolutePath();
        if (Files.exists(absPath, new LinkOption[0])) {
            return Files.isWritable(absPath);
        }
        if (absPath.getParent() == null) {
            return false;
        }
        return AbstractCommand.isWritable(absPath.getParent());
    }
}

