/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.jar.Manifest;
import org.wildfly.prospero.cli.CliConsole;
import picocli.CommandLine;

@CommandLine.Command(name="${prospero.dist.name}", resourceBundle="UsageMessages", versionProvider=VersionProvider.class)
public class MainCommand
implements Callable<Integer> {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    private final CliConsole console;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
    boolean help;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true)
    boolean version;
    @CommandLine.Option(names={"-vv", "--verbose"})
    boolean verbose;

    public MainCommand(CliConsole console) {
        this.console = console;
    }

    @Override
    public Integer call() throws IOException {
        ResourceBundle usageBundle = ResourceBundle.getBundle("UsageMessages");
        this.console.println(CommandLine.Help.Ansi.AUTO.string(usageBundle.getString("prospero.welcomeMessage")));
        this.spec.commandLine().usage(this.console.getStdOut());
        return 0;
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                if (!"prospero-cli".equals(manifest.getMainAttributes().getValue("Specification-Title"))) continue;
                return new String[]{manifest.getMainAttributes().getValue("Implementation-Version")};
            }
            return new String[]{"unknown"};
        }
    }
}

