/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.prospero.actions.ProvisioningAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.InstallationProfilesManager;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.ChannelUtils;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.LicensePrinter;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractInstallCommand;
import org.wildfly.prospero.cli.commands.options.InstallationProfilesCandidates;
import org.wildfly.prospero.cli.printers.ChannelPrinter;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.licenses.License;
import org.wildfly.prospero.model.InstallationProfile;
import picocli.CommandLine;

@CommandLine.Command(name="install", sortOptions=false)
public class InstallCommand
extends AbstractInstallCommand {
    protected static final int PROFILES_INDENT = 4;
    protected static final String PROFILE_SUBHEADERS_INDENT = "  ";
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--dir"}, required=false, order=2)
    Path directory;
    @CommandLine.Option(names={"--accept-license-agreements"}, order=8)
    boolean acceptAgreements;
    @CommandLine.Option(names={"--shade-repositories"}, split=",", hidden=true)
    List<String> shadowRepositories = new ArrayList<String>();
    protected static final List<String> STABILITY_LEVELS = List.of("experimental", "preview", "default", "community");
    @CommandLine.ArgGroup(headingKey="stability_level_header", exclusive=false, order=9)
    StabilityLevels stabilityLevels = new StabilityLevels();

    public InstallCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.featurePackOrDefinition.listProfiles) {
            return this.displayListOfProfiles();
        }
        if (this.directory == null) {
            throw CliMessages.MESSAGES.missingRequiredParameter(this.spec.commandLine(), "--dir");
        }
        assert (this.featurePackOrDefinition.definition.isPresent() || this.featurePackOrDefinition.fpl.isPresent() || this.featurePackOrDefinition.profile.isPresent());
        if (this.featurePackOrDefinition.profile.isEmpty() && this.channelCoordinates.isEmpty() && this.manifestCoordinates.isEmpty()) {
            throw CliMessages.MESSAGES.channelsMandatoryWhenCustomFpl(String.join((CharSequence)",", InstallationProfilesManager.getNames()));
        }
        if (this.featurePackOrDefinition.profile.isPresent() && !this.isStandardFpl(this.featurePackOrDefinition.profile.get())) {
            throw CliMessages.MESSAGES.unknownInstallationProfile(this.featurePackOrDefinition.profile.get(), String.join((CharSequence)",", InstallationProfilesManager.getNames()));
        }
        if (!this.channelCoordinates.isEmpty() && !this.manifestCoordinates.isEmpty()) {
            throw CliMessages.MESSAGES.exclusiveOptions("--channels", "--manifest");
        }
        if (!this.manifestCoordinates.isEmpty()) {
            for (String coordinate : this.manifestCoordinates) {
                ChannelManifestCoordinate manifest = ArtifactUtils.manifestCoordFromString(coordinate);
                this.checkFileExists(manifest.getUrl(), coordinate);
            }
        }
        if (!this.channelCoordinates.isEmpty()) {
            for (String coordStr : this.channelCoordinates) {
                ChannelCoordinate coord = ArtifactUtils.channelCoordFromString(coordStr);
                this.checkFileExists(coord.getUrl(), coordStr);
            }
        }
        this.stabilityLevels.verify();
        if (this.featurePackOrDefinition.definition.isPresent()) {
            Path definition = this.featurePackOrDefinition.definition.get().toAbsolutePath();
            this.checkFileExists(definition.toUri().toURL(), definition.toString());
        }
        InstallCommand.verifyTargetDirectoryIsEmpty(this.directory);
        ProvisioningDefinition provisioningDefinition = this.buildDefinition().setStabilityLevel(this.stabilityLevels.stabilityLevel == null ? null : this.stabilityLevels.stabilityLevel.toLowerCase(Locale.ROOT)).setPackageStabilityLevel(this.stabilityLevels.packageStabilityLevel == null ? null : this.stabilityLevels.packageStabilityLevel.toLowerCase(Locale.ROOT)).setConfigStabilityLevel(this.stabilityLevels.configStabilityLevel == null ? null : this.stabilityLevels.configStabilityLevel.toLowerCase(Locale.ROOT)).build();
        MavenOptions mavenOptions = this.getMavenOptions();
        GalleonProvisioningConfig provisioningConfig = provisioningDefinition.toProvisioningConfig();
        List<Channel> channels = ChannelUtils.resolveChannels(provisioningDefinition, mavenOptions);
        try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
            List<Repository> repositories = RepositoryDefinition.from(this.shadowRepositories);
            List<Repository> shadowRepositories = RepositoryUtils.unzipArchives(repositories, temporaryFiles);
            ProvisioningAction provisioningAction = this.actionFactory.install(this.directory.toAbsolutePath(), mavenOptions, this.console);
            if (this.featurePackOrDefinition.fpl.isPresent()) {
                this.console.println(CliMessages.MESSAGES.installingFpl(this.featurePackOrDefinition.fpl.get()));
            } else if (this.featurePackOrDefinition.profile.isPresent()) {
                this.console.println(CliMessages.MESSAGES.installingProfile(this.featurePackOrDefinition.profile.get()));
            } else if (this.featurePackOrDefinition.definition.isPresent()) {
                this.console.println(CliMessages.MESSAGES.installingDefinition(this.featurePackOrDefinition.definition.get()));
            }
            List<Channel> effectiveChannels = TemporaryRepositoriesHandler.overrideRepositories(channels, shadowRepositories);
            this.console.println(CliMessages.MESSAGES.usingChannels());
            ChannelPrinter channelPrinter = new ChannelPrinter(this.console);
            for (Channel channel : effectiveChannels) {
                channelPrinter.print(channel);
            }
            this.console.println("");
            List<License> pendingLicenses = provisioningAction.getPendingLicenses(provisioningConfig, effectiveChannels);
            if (!pendingLicenses.isEmpty()) {
                new LicensePrinter(this.console).print(pendingLicenses);
                this.console.println("");
                if (this.acceptAgreements) {
                    this.console.println(CliMessages.MESSAGES.agreementSkipped("--accept-license-agreements"));
                    this.console.println("");
                } else if (!this.console.confirm(CliMessages.MESSAGES.acceptAgreements(), "", CliMessages.MESSAGES.installationCancelled())) {
                    Integer n = 1;
                    return n;
                }
            }
            provisioningAction.provision(provisioningConfig, channels, shadowRepositories);
            this.console.println("");
            this.console.println(CliMessages.MESSAGES.installComplete(this.directory));
            float f = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(f));
            Integer n = 0;
            return n;
        }
    }

    private void checkFileExists(URL resourceUrl, String argValue) throws ArgumentParsingException {
        if (resourceUrl != null) {
            try {
                resourceUrl.openStream().close();
            }
            catch (IOException e) {
                throw CliMessages.MESSAGES.missingRequiresResource(argValue, e);
            }
        }
    }

    private boolean isStandardFpl(String fpl) {
        return InstallationProfilesManager.isWellKnownName(fpl);
    }

    private int displayListOfProfiles() throws ProvisioningException {
        Set<String> profiles = InstallationProfilesManager.getNames();
        if (profiles.isEmpty()) {
            this.console.println(CliMessages.MESSAGES.noAvailableProfiles() + "\n");
        } else {
            this.console.println(CliMessages.MESSAGES.availableProfiles() + "\n");
        }
        ChannelPrinter channelPrinter = new ChannelPrinter(this.console, 4);
        for (String profileName : profiles) {
            this.console.println("----------");
            this.console.println(CliMessages.MESSAGES.getProfile() + profileName);
            InstallationProfile profile = InstallationProfilesManager.getByName(profileName);
            this.console.println(PROFILE_SUBHEADERS_INDENT + CliMessages.MESSAGES.subscribedChannels());
            for (Channel channel : profile.getChannels()) {
                channelPrinter.print(channel);
            }
            this.console.println(PROFILE_SUBHEADERS_INDENT + CliMessages.MESSAGES.includedFeaturePacks());
            for (FeaturePackLocation featurePackLocation : this.getFeaturePacks(profile)) {
                this.console.println(" ".repeat(4) + featurePackLocation.toString());
            }
        }
        return 0;
    }

    private List<FeaturePackLocation> getFeaturePacks(InstallationProfile profile) throws ProvisioningException {
        try {
            GalleonProvisioningConfig config = GalleonUtils.loadProvisioningConfig(profile.getGalleonConfiguration());
            if (config.getFeaturePackDeps().isEmpty()) {
                throw new ProvisioningException("At least one feature pack location must be specified in the provisioning configuration");
            }
            return config.getFeaturePackDeps().stream().map(GalleonFeaturePackConfig::getLocation).collect(Collectors.toList());
        }
        catch (XMLStreamException e) {
            throw new ProvisioningException("Unable to parse provisioning configuration", e);
        }
    }

    static class StabilityLevels {
        @CommandLine.Option(names={"--stability-level"}, completionCandidates=StabilityCandidates.class, paramLabel="stability-level")
        String stabilityLevel;
        @CommandLine.Option(names={"--config-stability-level"}, completionCandidates=StabilityCandidates.class, paramLabel="stability-level")
        String configStabilityLevel;
        @CommandLine.Option(names={"--package-stability-level"}, completionCandidates=StabilityCandidates.class, paramLabel="stability-level")
        String packageStabilityLevel;

        StabilityLevels() {
        }

        public void verify() {
            if (StringUtils.isNotEmpty(this.stabilityLevel) && StringUtils.isNotEmpty(this.configStabilityLevel)) {
                throw CliMessages.MESSAGES.exclusiveOptions("--stability-level", "--config-stability-level");
            }
            if (StringUtils.isNotEmpty(this.stabilityLevel) && StringUtils.isNotEmpty(this.packageStabilityLevel)) {
                throw CliMessages.MESSAGES.exclusiveOptions("--stability-level", "--package-stability-level");
            }
            if (this.stabilityLevel != null && !STABILITY_LEVELS.contains(this.stabilityLevel.toLowerCase(Locale.ROOT))) {
                throw CliMessages.MESSAGES.unknownStabilityLevel(this.stabilityLevel, STABILITY_LEVELS);
            }
            if (this.configStabilityLevel != null && !STABILITY_LEVELS.contains(this.configStabilityLevel.toLowerCase(Locale.ROOT))) {
                throw CliMessages.MESSAGES.unknownStabilityLevel(this.configStabilityLevel, STABILITY_LEVELS);
            }
            if (this.packageStabilityLevel != null && !STABILITY_LEVELS.contains(this.packageStabilityLevel.toLowerCase(Locale.ROOT))) {
                throw CliMessages.MESSAGES.unknownStabilityLevel(this.packageStabilityLevel, STABILITY_LEVELS);
            }
        }
    }

    private static class StabilityCandidates
    implements Iterable<String> {
        private StabilityCandidates() {
        }

        @Override
        public Iterator<String> iterator() {
            return STABILITY_LEVELS.stream().map(String::toLowerCase).iterator();
        }
    }

    static class FeaturePackOrDefinition {
        @CommandLine.Option(names={"--profile"}, paramLabel="<installation-profile>", completionCandidates=InstallationProfilesCandidates.class, required=true, order=1)
        Optional<String> profile;
        @CommandLine.Option(names={"--fpl"}, paramLabel="<feature-pack-reference>", required=true, order=2)
        Optional<String> fpl;
        @CommandLine.Option(names={"--definition"}, paramLabel="<path>", required=true, order=3)
        Optional<Path> definition;
        @CommandLine.Option(names={"--list-profiles"}, order=4)
        boolean listProfiles;

        FeaturePackOrDefinition() {
        }
    }
}

