/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.diff.FsEntryFactory;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.logging.Logger;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.SubscribeNewServerAction;
import org.wildfly.prospero.actions.UpdateAction;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationProfilesManager;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.DistributionInfo;
import org.wildfly.prospero.cli.FileConflictPrinter;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.AbstractMavenCommand;
import org.wildfly.prospero.cli.commands.AbstractParentCommand;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;
import org.wildfly.prospero.model.InstallationProfile;
import org.wildfly.prospero.updates.UpdateSet;
import picocli.CommandLine;

@CommandLine.Command(name="update", sortOptions=false)
public class UpdateCommand
extends AbstractParentCommand {
    private static final Logger log = Logger.getLogger(UpdateCommand.class);
    public static final String JBOSS_MODULE_PATH = "module.path";
    public static final String PROSPERO_FP_GA = "org.wildfly.prospero:prospero-standalone-galleon-pack";
    public static final String PROSPERO_FP_ZIP = "org.wildfly.prospero:prospero-standalone-galleon-pack::zip";

    public UpdateCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory, "update", List.of(new PrepareCommand(console, actionFactory), new ApplyCommand(console, actionFactory), new PerformCommand(console, actionFactory), new ListCommand(console, actionFactory), new SubscribeCommand(console, actionFactory)));
    }

    private static boolean buildUpdate(UpdateAction updateAction, Path updateDirectory, boolean yes, CliConsole console, Supplier<Boolean> confirmation) throws OperationException, ProvisioningException {
        UpdateSet updateSet = updateAction.findUpdates();
        console.updatesFound(updateSet.getArtifactUpdates());
        if (updateSet.isEmpty()) {
            return false;
        }
        if (!yes && !confirmation.get().booleanValue()) {
            return false;
        }
        updateAction.buildUpdate(updateDirectory.toAbsolutePath());
        return true;
    }

    public static void verifyInstallationContainsOnlyProspero(Path dir) throws ArgumentParsingException {
        UpdateCommand.verifyDirectoryContainsInstallation(dir);
        try {
            List<String> fpNames = GalleonUtils.getInstalledPacks(dir.toAbsolutePath());
            if (fpNames.size() != 1) {
                throw CliMessages.MESSAGES.unexpectedPackageInSelfUpdate(dir.toString());
            }
            if (!fpNames.stream().allMatch(PROSPERO_FP_ZIP::equals)) {
                throw CliMessages.MESSAGES.unexpectedPackageInSelfUpdate(dir.toString());
            }
        }
        catch (ProvisioningException e) {
            throw CliMessages.MESSAGES.unableToParseSelfUpdateData(e);
        }
    }

    public static Path detectProsperoInstallationPath() throws ArgumentParsingException {
        String modulePath = System.getProperty(JBOSS_MODULE_PATH);
        if (modulePath == null) {
            throw CliMessages.MESSAGES.unableToLocateProsperoInstallation();
        }
        return Paths.get(modulePath, new String[0]).toAbsolutePath().getParent();
    }

    @CommandLine.Command(name="subscribe", sortOptions=false)
    public static class SubscribeCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--product"})
        String product;
        @CommandLine.Option(names={"--version"})
        String version;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public SubscribeCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            Path installDir = this.directory.orElse(SubscribeCommand.currentDir()).toAbsolutePath();
            if (Files.exists(ProsperoMetadataUtils.manifestPath(installDir), new LinkOption[0]) || Files.exists(ProsperoMetadataUtils.configurationPath(installDir), new LinkOption[0])) {
                this.console.println(CliMessages.MESSAGES.metadataExistsAlready(installDir, DistributionInfo.DIST_NAME));
                return 2;
            }
            if (this.product == null || this.version == null) {
                this.console.println(CliMessages.MESSAGES.productAndVersionNotNull());
                return 2;
            }
            InstallationProfile installationProfile = InstallationProfilesManager.getByName(this.product);
            if (installationProfile == null) {
                this.console.println(CliMessages.MESSAGES.unknownProduct(this.product));
                return 2;
            }
            List<Channel> channels = installationProfile.getChannels();
            FeaturePackLocation loc = this.getFpl(installationProfile, this.version);
            log.debugf("Will generate FeaturePackLocation %s.", (Object)loc.toString());
            SubscribeNewServerAction subscribeNewServerAction = this.actionFactory.subscribeNewServerAction(this.parseMavenOptions(), this.console);
            SubscribeNewServerAction.GenerateResult generateResult = subscribeNewServerAction.generateServerMetadata(channels, loc);
            this.generateMeta(installDir, generateResult);
            return 0;
        }

        private void generateMeta(Path installDir, SubscribeNewServerAction.GenerateResult generateResult) throws IOException, ProvisioningException {
            FsEntryFactory fsEntryFactory = FsEntryFactory.getInstance().filterGalleonPaths().filter(".installation");
            FsEntry originalState = fsEntryFactory.forPath(generateResult.getProvisionDir());
            FsEntry currentState = fsEntryFactory.forPath(installDir);
            FsDiff diff = FsDiff.diff(originalState, currentState);
            if (!this.yes && SubscribeCommand.hasChangedEntries(diff) && !this.console.confirm(CliMessages.MESSAGES.conflictsWhenGenerating(diff.toString()), CliMessages.MESSAGES.continueGenerating(), CliMessages.MESSAGES.quitGenerating())) {
                return;
            }
            Path galleonDir = installDir.resolve(".galleon");
            if (Files.notExists(galleonDir, new LinkOption[0])) {
                Files.createDirectories(galleonDir, new FileAttribute[0]);
            }
            Path provisionDir = generateResult.getProvisionDir();
            Path sourceGalleonDir = provisionDir.resolve(".galleon");
            if (!Files.exists(galleonDir.getParent(), new LinkOption[0])) {
                Files.createDirectories(galleonDir.getParent(), new FileAttribute[0]);
            }
            FileUtils.copyDirectory(sourceGalleonDir.toFile(), galleonDir.toFile());
            ChannelManifest manifest = generateResult.getManifest();
            Path manifestPath = ProsperoMetadataUtils.manifestPath(installDir);
            if (!Files.exists(manifestPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
            }
            this.console.println(CliMessages.MESSAGES.writeManifest(manifestPath));
            ProsperoMetadataUtils.writeManifest(manifestPath, manifest);
            List<Channel> channels = generateResult.getChannels();
            if (!generateResult.isManifestCoordDefined()) {
                Path manifestPathCopy = manifestPath.getParent().resolve("manifest-" + this.product + "-" + this.version + ".yaml");
                Files.copy(manifestPath, manifestPathCopy, StandardCopyOption.REPLACE_EXISTING);
                channels = channels.stream().map(c -> {
                    try {
                        return new Channel(c.getName(), c.getDescription(), c.getVendor(), c.getRepositories(), new ChannelManifestCoordinate(manifestPathCopy.toUri().toURL()), c.getBlocklistCoordinate(), c.getNoStreamStrategy());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            }
            Path channelsPath = ProsperoMetadataUtils.configurationPath(installDir);
            this.console.println(CliMessages.MESSAGES.writeChannelsConfiguration(channelsPath));
            ProsperoMetadataUtils.writeChannelsConfiguration(channelsPath, channels);
        }

        private static boolean hasChangedEntries(FsDiff diff) {
            return diff.hasAddedEntries() || diff.hasModifiedEntries() || diff.hasRemovedEntries();
        }

        private FeaturePackLocation getFpl(InstallationProfile knownFeaturePack, String version) throws XMLStreamException, ProvisioningException {
            GalleonProvisioningConfig config = GalleonUtils.loadProvisioningConfig(knownFeaturePack.getGalleonConfiguration());
            if (config.getFeaturePackDeps().isEmpty()) {
                throw new ProvisioningException("At least one feature pack location must be specified in the provisioning configuration");
            }
            FeaturePackLocation fpl = config.getFeaturePackDeps().iterator().next().getLocation();
            String[] split = fpl.toString().split(":");
            return FeaturePackLocationParser.resolveFpl(split[0] + ":" + split[1] + ":" + version);
        }
    }

    @CommandLine.Command(name="list", sortOptions=false)
    public static class ListCommand
    extends AbstractMavenCommand {
        public ListCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            Path installationDir = ListCommand.determineInstallationDirectory(this.directory);
            MavenOptions mavenOptions = this.parseMavenOptions();
            try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
                List<Repository> repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.temporaryRepositories), temporaryFiles);
                this.console.println(CliMessages.MESSAGES.checkUpdatesHeader(installationDir));
                try (UpdateAction updateAction = this.actionFactory.update(installationDir, mavenOptions, this.console, repositories);){
                    UpdateSet updateSet = updateAction.findUpdates();
                    this.console.updatesFound(updateSet.getArtifactUpdates());
                }
                float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
                this.console.println("");
                this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
                Integer n = 0;
                return n;
            }
        }
    }

    @CommandLine.Command(name="apply", sortOptions=false)
    public static class ApplyCommand
    extends AbstractCommand {
        @CommandLine.Option(names={"--dir"})
        Optional<Path> directory;
        @CommandLine.Option(names={"--candidate-dir"}, required=true)
        Path candidateDir;
        @CommandLine.Option(names={"--rm"})
        boolean remove;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public ApplyCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            Path installationDir = ApplyCommand.determineInstallationDirectory(this.directory);
            if (!ApplyCommand.verifyDirectoryContainsInstallation(this.candidateDir)) {
                throw CliMessages.MESSAGES.invalidInstallationDir(this.candidateDir);
            }
            this.console.println(CliMessages.MESSAGES.updateHeader(installationDir));
            ApplyCandidateAction applyCandidateAction = this.actionFactory.applyUpdate(installationDir.toAbsolutePath(), this.candidateDir.toAbsolutePath());
            ApplyCandidateAction.ValidationResult result = applyCandidateAction.verifyCandidate(ApplyCandidateAction.Type.UPDATE);
            if (ApplyCandidateAction.ValidationResult.STALE == result) {
                throw CliMessages.MESSAGES.updateCandidateStateNotMatched(installationDir, this.candidateDir.toAbsolutePath());
            }
            if (ApplyCandidateAction.ValidationResult.WRONG_TYPE == result) {
                throw CliMessages.MESSAGES.updateCandidateWrongType(installationDir, ApplyCandidateAction.Type.UPDATE);
            }
            if (ApplyCandidateAction.ValidationResult.NOT_CANDIDATE == result) {
                throw CliMessages.MESSAGES.notCandidate(this.candidateDir.toAbsolutePath());
            }
            this.console.updatesFound(applyCandidateAction.findUpdates().getArtifactUpdates());
            List<FileConflict> conflicts = applyCandidateAction.getConflicts();
            FileConflictPrinter.print(conflicts, this.console);
            if (!this.yes && !this.console.confirm(CliMessages.MESSAGES.continueWithUpdate(), CliMessages.MESSAGES.applyingUpdates(), CliMessages.MESSAGES.updateCancelled())) {
                return 0;
            }
            applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.UPDATE);
            this.console.updatesComplete();
            if (this.remove) {
                applyCandidateAction.removeCandidate(this.candidateDir.toFile());
            }
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }
    }

    @CommandLine.Command(name="prepare", sortOptions=false)
    public static class PrepareCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--candidate-dir"}, required=true)
        Path candidateDirectory;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public PrepareCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            long startTime = System.currentTimeMillis();
            Path installationDir = PrepareCommand.determineInstallationDirectory(this.directory);
            MavenOptions mavenOptions = this.parseMavenOptions();
            try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
                List<Repository> repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.temporaryRepositories), temporaryFiles);
                log.tracef("Generate update in %s", (Object)this.candidateDirectory);
                this.console.println(CliMessages.MESSAGES.buildUpdateCandidateHeader(installationDir));
                PrepareCommand.verifyTargetDirectoryIsEmpty(this.candidateDirectory);
                try (UpdateAction updateAction = this.actionFactory.update(installationDir, mavenOptions, this.console, repositories);){
                    if (UpdateCommand.buildUpdate(updateAction, this.candidateDirectory, this.yes, this.console, () -> this.console.confirmBuildUpdates())) {
                        this.console.println("");
                        this.console.buildUpdatesComplete();
                        this.console.println(CliMessages.MESSAGES.updateCandidateGenerated(this.candidateDirectory));
                    }
                }
            }
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }
    }

    @CommandLine.Command(name="perform", sortOptions=false)
    public static class PerformCommand
    extends AbstractMavenCommand {
        @CommandLine.Option(names={"--self"})
        boolean self;
        @CommandLine.Option(names={"-y", "--yes"})
        boolean yes;

        public PerformCommand(CliConsole console, ActionFactory actionFactory) {
            super(console, actionFactory);
        }

        @Override
        public Integer call() throws Exception {
            Path installationDir;
            long startTime = System.currentTimeMillis();
            if (this.self) {
                installationDir = this.directory.isPresent() ? ((Path)this.directory.get()).toAbsolutePath() : UpdateCommand.detectProsperoInstallationPath().toAbsolutePath();
                UpdateCommand.verifyInstallationContainsOnlyProspero(installationDir);
            } else {
                installationDir = PerformCommand.determineInstallationDirectory(this.directory);
            }
            MavenOptions mavenOptions = this.parseMavenOptions();
            try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
                List<Repository> repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.temporaryRepositories), temporaryFiles);
                log.tracef("Perform full update", new Object[0]);
                this.console.println(CliMessages.MESSAGES.updateHeader(installationDir));
                try (UpdateAction updateAction = this.actionFactory.update(installationDir, mavenOptions, this.console, repositories);){
                    this.performUpdate(updateAction, this.yes, this.console, installationDir);
                }
            }
            float totalTime = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
            this.console.println(CliMessages.MESSAGES.operationCompleted(totalTime));
            return 0;
        }

        private boolean performUpdate(UpdateAction updateAction, boolean yes, CliConsole console, Path installDir) throws OperationException, ProvisioningException {
            block10: {
                Path targetDir = null;
                try {
                    targetDir = Files.createTempDirectory("update-candidate", new FileAttribute[0]);
                    if (UpdateCommand.buildUpdate(updateAction, targetDir, yes, console, () -> console.confirmUpdates())) {
                        console.println("");
                        console.buildUpdatesComplete();
                        ApplyCandidateAction applyCandidateAction = this.actionFactory.applyUpdate(installDir, targetDir);
                        List<FileConflict> conflicts = applyCandidateAction.getConflicts();
                        if (!conflicts.isEmpty()) {
                            FileConflictPrinter.print(conflicts, console);
                            if (!yes && !console.confirm(CliMessages.MESSAGES.continueWithUpdate(), "", CliMessages.MESSAGES.updateCancelled())) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        console.println(CliMessages.MESSAGES.applyingUpdates());
                        applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.UPDATE);
                        break block10;
                    }
                    boolean applyCandidateAction = false;
                    return applyCandidateAction;
                }
                catch (IOException e) {
                    throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
                }
                finally {
                    if (targetDir != null) {
                        FileUtils.deleteQuietly(targetDir.toFile());
                    }
                }
            }
            console.updatesComplete();
            return true;
        }
    }
}

