/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands.channel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.MetadataAction;
import org.wildfly.prospero.api.ArtifactUtils;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.CliMessages;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="add", sortOptions=false)
public class ChannelAddCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--channel-name"}, required=true)
    private String channelName;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    private ChannelParamsGroup channelOptions;
    @CommandLine.Option(names={"--dir"})
    private Optional<Path> directory;

    public ChannelAddCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    @Override
    public Integer call() throws Exception {
        Channel channel;
        Path installationDirectory = ChannelAddCommand.determineInstallationDirectory(this.directory);
        if (this.channelOptions.channelLocation != null) {
            channel = this.readChannelFromDefinition();
        } else {
            ChannelManifestCoordinate manifest = ArtifactUtils.manifestCoordFromString(this.channelOptions.channelGroup.manifestLocation);
            try (TemporaryFilesManager temporaryFiles = TemporaryFilesManager.getInstance();){
                List<Repository> repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.channelOptions.channelGroup.repositoryDefs), temporaryFiles);
                channel = new Channel(this.channelName, null, null, repositories, manifest, null, null);
            }
        }
        this.console.println(CliMessages.MESSAGES.subscribeChannel(installationDirectory, this.channelName));
        try (MetadataAction metadataAction = this.actionFactory.metadataActions(installationDirectory);){
            metadataAction.addChannel(channel);
        }
        this.console.println(CliMessages.MESSAGES.channelAdded(this.channelName));
        return 0;
    }

    private Channel readChannelFromDefinition() throws OperationException, ArgumentParsingException {
        Path channelFile = this.channelOptions.channelLocation.toAbsolutePath();
        try {
            List<Channel> channels = ChannelMapper.fromString(Files.readString(channelFile));
            Channel channel = channels.get(0);
            if (channels.size() > 1) {
                throw CliMessages.MESSAGES.sizeOfChannel(channelFile);
            }
            return new Channel(this.channelName, channel.getDescription(), channel.getVendor(), channel.getRepositories(), channel.getManifestCoordinate(), channel.getBlocklistCoordinate(), channel.getNoStreamStrategy());
        }
        catch (InvalidChannelMetadataException e) {
            throw ProsperoLogger.ROOT_LOGGER.invalidChannel(e);
        }
        catch (IOException e) {
            throw CliMessages.MESSAGES.missingRequiresResource(channelFile.toString(), e);
        }
    }

    static class ChannelGroup {
        @CommandLine.Option(names={"--manifest"}, required=true)
        private String manifestLocation;
        @CommandLine.Option(names={"--repositories"}, split=",", paramLabel="<repo-url>", required=true)
        private List<String> repositoryDefs;

        ChannelGroup() {
        }
    }

    static class ChannelParamsGroup {
        @CommandLine.Option(names={"--channel"})
        private Path channelLocation;
        @CommandLine.ArgGroup(exclusive=false, multiplicity="1")
        private ChannelGroup channelGroup;

        ChannelParamsGroup() {
        }
    }
}

