/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.wildfly.prospero.ProsperoLogger;

class ApplyStageBackup
implements AutoCloseable {
    protected static final String BACKUP_FOLDER = ".update.old";
    private final Path backupRoot;
    private final Path serverRoot;
    private final Path candidateRoot;

    ApplyStageBackup(Path serverRoot, Path candidateRoot) throws IOException {
        this.serverRoot = serverRoot;
        this.candidateRoot = candidateRoot;
        this.backupRoot = serverRoot.resolve(BACKUP_FOLDER);
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("Creating backup record in " + this.backupRoot);
        }
        if (!Files.exists(this.backupRoot, new LinkOption[0])) {
            if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                ProsperoLogger.ROOT_LOGGER.trace("Creating backup directory in " + this.backupRoot);
            }
            Files.createDirectories(this.backupRoot, new FileAttribute[0]);
        } else if (!Files.isDirectory(this.backupRoot, new LinkOption[0]) || !Files.isWritable(this.backupRoot)) {
            throw new RuntimeException(String.format("Unable to create backup in %s. It is not a directory or is not writable.", this.backupRoot));
        }
        File[] files = this.backupRoot.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                    ProsperoLogger.ROOT_LOGGER.trace("Removing existing backup files: " + file);
                }
                FileUtils.forceDelete(file);
            }
        }
    }

    public void recordAll() throws IOException {
        Files.walkFileTree(this.serverRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return ApplyStageBackup.this.ignoreUserManagedFiles(file, exc);
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(ApplyStageBackup.this.backupRoot)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path relative = ApplyStageBackup.this.serverRoot.relativize(dir);
                Files.createDirectories(ApplyStageBackup.this.backupRoot.resolve(relative), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ApplyStageBackup.this.isUserProtectedFile(file)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path relative = ApplyStageBackup.this.serverRoot.relativize(file);
                if (relative.startsWith(Path.of(".installation", ".git"))) {
                    Files.copy(file, ApplyStageBackup.this.backupRoot.resolve(relative), new CopyOption[0]);
                } else {
                    try {
                        Files.createLink(ApplyStageBackup.this.backupRoot.resolve(relative), file);
                    }
                    catch (UnsupportedOperationException e) {
                        Files.copy(file, ApplyStageBackup.this.backupRoot.resolve(relative), new CopyOption[0]);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Override
    public void close() {
        FileUtils.deleteQuietly(this.backupRoot.toFile());
    }

    public void restore() throws IOException {
        if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
            ProsperoLogger.ROOT_LOGGER.debug("Restoring server from the backup.");
        }
        if (!Files.exists(this.backupRoot, new LinkOption[0])) {
            throw new RuntimeException("Backup root doesn't exist.");
        }
        Files.walkFileTree(this.backupRoot, this.restoreModifiedFiles());
        Files.walkFileTree(this.serverRoot, this.deleteNewFiles());
    }

    private SimpleFileVisitor<Path> deleteNewFiles() {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return ApplyStageBackup.this.ignoreUserManagedFiles(file, exc);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (ApplyStageBackup.this.isUserProtectedFile(file)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path relativePath = ApplyStageBackup.this.serverRoot.relativize(file);
                if (!Files.exists(ApplyStageBackup.this.backupRoot.resolve(relativePath), new LinkOption[0])) {
                    if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.trace("Removing added file " + relativePath);
                    }
                    Files.delete(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Path relativePath = ApplyStageBackup.this.serverRoot.relativize(dir);
                if (!Files.exists(ApplyStageBackup.this.backupRoot.resolve(relativePath), new LinkOption[0])) {
                    if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.trace("Removing added directory " + relativePath);
                    }
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(ApplyStageBackup.this.backupRoot)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private FileVisitResult ignoreUserManagedFiles(Path file, IOException exc) throws IOException {
        if (this.isUserProtectedFile(file)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        throw exc;
    }

    private boolean isUserProtectedFile(Path file) {
        Path relative = this.serverRoot.relativize(file);
        Path candidatePath = this.candidateRoot.resolve(relative);
        return !Files.isReadable(file) && !Files.exists(candidatePath, new LinkOption[0]);
    }

    private SimpleFileVisitor<Path> restoreModifiedFiles() {
        return new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile;
                Path relativePath = ApplyStageBackup.this.backupRoot.relativize(file);
                Path parentDir = relativePath.getParent();
                if (parentDir != null && !Files.exists(ApplyStageBackup.this.serverRoot.resolve(parentDir), new LinkOption[0])) {
                    if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.trace("Recreating removed directory " + parentDir);
                    }
                    Files.createDirectories(ApplyStageBackup.this.serverRoot.resolve(parentDir), new FileAttribute[0]);
                }
                if (ApplyStageBackup.fileChanged(file, targetFile = ApplyStageBackup.this.serverRoot.resolve(relativePath))) {
                    if (ProsperoLogger.ROOT_LOGGER.isTraceEnabled()) {
                        ProsperoLogger.ROOT_LOGGER.trace("Restoring changed file " + relativePath);
                    }
                    Files.copy(file, targetFile, StandardCopyOption.REPLACE_EXISTING);
                }
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private static boolean fileChanged(Path file, Path targetFile) throws IOException {
        if (!Files.exists(targetFile, new LinkOption[0])) {
            return true;
        }
        try (FileInputStream fis1 = new FileInputStream(targetFile.toFile());){
            boolean bl;
            try (FileInputStream fis2 = new FileInputStream(file.toFile());){
                bl = !IOUtils.contentEquals(fis1, fis2);
            }
            return bl;
        }
    }
}

