/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.InstallFolderUtils;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.updates.UpdateFinder;
import org.wildfly.prospero.updates.UpdateSet;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class UpdateAction
implements AutoCloseable {
    private final InstallationMetadata metadata;
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final Console console;
    private final ProsperoConfig prosperoConfig;
    private final MavenOptions mavenOptions;

    public UpdateAction(Path installDir, MavenOptions mavenOptions, Console console, List<Repository> overrideRepositories) throws OperationException, ProvisioningException {
        this.installDir = InstallFolderUtils.toRealPath(installDir);
        this.metadata = InstallationMetadata.loadInstallation(this.installDir);
        this.console = console;
        this.prosperoConfig = this.addTemporaryRepositories(overrideRepositories);
        this.mavenOptions = this.prosperoConfig.getMavenOptions().merge(mavenOptions);
        this.mavenSessionManager = new MavenSessionManager(this.mavenOptions);
    }

    public List<FileConflict> performUpdate() throws OperationException, ProvisioningException {
        ProsperoLogger.ROOT_LOGGER.performUpdateStarted(this.installDir);
        Path targetDir = null;
        try {
            targetDir = Files.createTempDirectory("update-candidate", new FileAttribute[0]);
            if (ProsperoLogger.ROOT_LOGGER.isDebugEnabled()) {
                ProsperoLogger.ROOT_LOGGER.temporaryCandidateFolder(targetDir);
            }
            if (this.buildUpdate(targetDir)) {
                ApplyCandidateAction applyCandidateAction = new ApplyCandidateAction(this.installDir, targetDir);
                List<FileConflict> list = applyCandidateAction.applyUpdate(ApplyCandidateAction.Type.UPDATE);
                return list;
            }
            List<FileConflict> applyCandidateAction = Collections.emptyList();
            return applyCandidateAction;
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (targetDir != null) {
                FileUtils.deleteQuietly(targetDir.toFile());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean buildUpdate(Path targetDir) throws ProvisioningException, OperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public UpdateSet findUpdates() throws OperationException, ProvisioningException {
        ProsperoLogger.ROOT_LOGGER.checkingUpdates();
        try (GalleonEnvironment galleonEnv = this.getGalleonEnv(this.installDir);){
            UpdateFinder updateFinder = new UpdateFinder(galleonEnv.getChannelSession());
            try {
                UpdateSet updates = updateFinder.findUpdates(this.metadata.getArtifacts());
                ProsperoLogger.ROOT_LOGGER.updatesFound(updates.getArtifactUpdates().size());
                UpdateSet updateSet = updates;
                updateFinder.close();
                return updateSet;
            }
            catch (Throwable throwable) {
                try {
                    updateFinder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private GalleonEnvironment getGalleonEnv(Path target) throws ProvisioningException, OperationException {
        return GalleonEnvironment.builder(target, this.prosperoConfig.getChannels(), this.mavenSessionManager, false).setSourceServerPath(this.installDir).setConsole(this.console).build();
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private ProsperoConfig addTemporaryRepositories(List<Repository> repositories) {
        ProsperoConfig prosperoConfig = this.metadata.getProsperoConfig();
        List<Channel> channels = TemporaryRepositoriesHandler.overrideRepositories(prosperoConfig.getChannels(), repositories);
        return new ProsperoConfig(channels, prosperoConfig.getMavenOptions());
    }
}

