/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import picocli.CommandLine;

public abstract class AbstractInstallCommand
extends AbstractCommand {
    @CommandLine.ArgGroup(heading="%nInstallation source:%n", exclusive=true, multiplicity="1", order=1)
    InstallCommand.FeaturePackOrDefinition featurePackOrDefinition;
    @CommandLine.Option(names={"--channels", "--channel"}, paramLabel="<channel-reference>", order=2, split=",")
    List<String> channelCoordinates = new ArrayList<String>();
    @CommandLine.Option(names={"--manifest"}, paramLabel="<manifest-reference>", split=",", order=3)
    List<String> manifestCoordinates = Collections.emptyList();
    @CommandLine.Option(names={"--repositories"}, paramLabel="<repo-url>", split=",", order=4)
    List<String> remoteRepositories = new ArrayList<String>();
    @CommandLine.ArgGroup(exclusive=true, order=5, headingKey="localRepoOptions.heading")
    LocalRepoOptions localRepoOptions = new LocalRepoOptions();
    @CommandLine.Option(names={"--offline"}, order=6)
    Optional<Boolean> offline = Optional.empty();

    public AbstractInstallCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    protected MavenOptions getMavenOptions() throws ArgumentParsingException {
        MavenOptions.Builder mavenOptions = this.localRepoOptions.toOptions();
        this.offline.map(mavenOptions::setOffline);
        return mavenOptions.build();
    }

    protected ProvisioningDefinition.Builder buildDefinition() throws ArgumentParsingException {
        return ProvisioningDefinition.builder().setFpl(this.featurePackOrDefinition.fpl.orElse(null)).setProfile(this.featurePackOrDefinition.profile.orElse(null)).setManifests(this.manifestCoordinates).setChannelCoordinates(this.channelCoordinates).setOverrideRepositories(RepositoryDefinition.from(this.remoteRepositories)).setDefinitionFile(this.featurePackOrDefinition.definition.map(Path::toUri).orElse(null));
    }
}

