/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.prospero.galleon.FeaturePackLocationParser;

class ProvisioningConfigManipulator {
    private final GalleonProvisioningConfig.Builder configBuilder;

    public ProvisioningConfigManipulator(GalleonProvisioningConfig.Builder configBuilder) {
        this.configBuilder = configBuilder;
    }

    int removeFeaturePackDefinition(String fpName) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(depFpl.getLocation());
        return fpIndex;
    }

    int convertToTransitiveDep(String fpName, GalleonProvisioningConfig originalConfig) throws ProvisioningException {
        FeaturePackLocation.ProducerSpec depFpl = FeaturePackLocationParser.resolveFpl(fpName).getProducer();
        GalleonFeaturePackConfig oldConfig = originalConfig.getFeaturePackDep(depFpl);
        int fpIndex = this.configBuilder.getFeaturePackDepIndex(depFpl.getLocation());
        this.configBuilder.removeFeaturePackDep(oldConfig.getLocation());
        GalleonFeaturePackConfig.Builder newFpBuilder = GalleonFeaturePackConfig.transitiveBuilder(oldConfig.getLocation());
        ProvisioningConfigManipulator.copyFeaturePackConfig(oldConfig, newFpBuilder);
        this.configBuilder.addFeaturePackDep(newFpBuilder.build());
        return fpIndex;
    }

    static void copyFeaturePackConfig(GalleonFeaturePackConfig originalConfig, GalleonFeaturePackConfig.Builder configBuilder) throws ProvisioningDescriptionException {
        if (originalConfig.getInheritPackages() != null) {
            configBuilder.setInheritPackages(originalConfig.getInheritPackages());
        }
        for (String string : originalConfig.getExcludedPackages()) {
            configBuilder.excludePackage(string);
        }
        for (String string : originalConfig.getIncludedPackages()) {
            configBuilder.includePackage(string);
        }
        for (FeaturePackLocation.FPID fPID : originalConfig.getPatches()) {
            configBuilder.addPatch(fPID);
        }
        if (originalConfig.getInheritConfigs() != null) {
            configBuilder.setInheritConfigs(originalConfig.getInheritConfigs());
        }
        configBuilder.setInheritModelOnlyConfigs(originalConfig.isInheritModelOnlyConfigs());
        for (String string : originalConfig.getFullModelsIncluded()) {
            configBuilder.includeConfigModel(string);
        }
        for (String string : originalConfig.getFullModelsExcluded().keySet()) {
            configBuilder.excludeConfigModel(string);
        }
        for (ConfigId configId : originalConfig.getIncludedConfigs()) {
            configBuilder.includeDefaultConfig(configId);
        }
        for (ConfigId configId : originalConfig.getExcludedConfigs()) {
            configBuilder.excludeDefaultConfig(configId);
        }
        for (GalleonConfigurationWithLayers galleonConfigurationWithLayers : originalConfig.getDefinedConfigs()) {
            configBuilder.addConfig(galleonConfigurationWithLayers);
        }
    }
}

