/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.wildfly.prospero.model.InstallationProfile;

public abstract class InstallationProfilesManager {
    private static final Logger logger = Logger.getLogger(InstallationProfilesManager.class);
    private static final Map<String, InstallationProfile> nameMap = new HashMap<String, InstallationProfile>();

    public static InstallationProfile getByName(String name) {
        return nameMap.get(name);
    }

    public static boolean isWellKnownName(String name) {
        return nameMap.containsKey(name);
    }

    public static Set<String> getNames() {
        return nameMap.keySet();
    }

    private static URL findProfileDefinitions() {
        URL definition = InstallationProfilesManager.class.getClassLoader().getResource("prospero-installation-profiles.yaml");
        if (definition != null) {
            return definition;
        }
        return InstallationProfilesManager.class.getClassLoader().getResource("prospero-known-combinations.yaml");
    }

    static {
        URL knownRepoUrl = InstallationProfilesManager.findProfileDefinitions();
        if (knownRepoUrl == null) {
            logger.debug("No known repositories found");
        } else {
            logger.debug("Loading known provisioning configurations from: " + String.valueOf(knownRepoUrl));
            try {
                List<InstallationProfile> installationProfiles = InstallationProfile.readConfig(knownRepoUrl);
                for (InstallationProfile fp : installationProfiles) {
                    nameMap.put(fp.getName(), fp);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to load provisioning configurations from: " + String.valueOf(knownRepoUrl));
                logger.debug((Object)"Error parsing provisioning configurations:", e);
            }
        }
    }
}

