/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.galleon;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.GalleonBuilder;
import org.jboss.galleon.api.Provisioning;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.Console;
import org.wildfly.prospero.api.exceptions.ChannelDefinitionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.api.exceptions.UnresolvedChannelMetadataException;
import org.wildfly.prospero.galleon.CachedVersionResolverFactory;
import org.wildfly.prospero.galleon.ChannelManifestSubstitutor;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.DownloadsCallbackAdapter;
import org.wildfly.prospero.galleon.GalleonCallbackAdapter;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.galleon.MavenArtifactDirectResolverRepositoryManager;
import org.wildfly.prospero.galleon.MavenProxyHandler;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class GalleonEnvironment
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(GalleonEnvironment.class.getName());
    public static final String TRACK_JBMODULES = "JBMODULES";
    public static final String TRACK_JBEXAMPLES = "JBEXTRACONFIGS";
    public static final String TRACK_JB_ARTIFACTS_RESOLVE = "JB_ARTIFACTS_RESOLVE";
    public static final String TRACK_RESOLVING_VERSIONS = "RESOLVING_VERSIONS";
    private final Provisioning provisioning;
    private final MavenRepoManager repositoryManager;
    private final ChannelSession channelSession;
    private final List<Channel> channels;
    private Path restoreManifestPath = null;
    private boolean resetGalleonLineEndings = true;

    private GalleonEnvironment(Builder builder) throws ProvisioningException, MetadataException, ChannelDefinitionException, UnresolvedChannelMetadataException {
        MavenVersionsResolver.Factory factory;
        Optional<Console> console = Optional.ofNullable(builder.console);
        Optional<ChannelManifest> restoreManifest = Optional.ofNullable(builder.manifest);
        if (restoreManifest.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Replacing channel manifests with restore manifest");
            }
            this.channels = this.replaceManifestWithRestoreManifests(builder, restoreManifest);
        } else {
            this.channels = builder.channels;
        }
        ArrayList<Channel> substitutedChannels = new ArrayList<Channel>();
        ChannelManifestSubstitutor substitutor = new ChannelManifestSubstitutor(Map.of("installation.home", builder.installDir.toString()));
        for (Channel channel : this.channels) {
            substitutedChannels.add(substitutor.substitute(channel));
        }
        RepositorySystem system = builder.mavenSessionManager.newRepositorySystem();
        DefaultRepositorySystemSession session = builder.mavenSessionManager.newRepositorySystemSession(system);
        Path sourceServerPath = builder.sourceServerPath == null ? builder.installDir : builder.sourceServerPath;
        try {
            factory = new CachedVersionResolverFactory(new VersionResolverFactory(system, session, MavenProxyHandler::addProxySettings), sourceServerPath, system, session);
        }
        catch (IOException e) {
            ProsperoLogger.ROOT_LOGGER.debug("Unable to read artifact cache, falling back to Maven resolver.", e);
            factory = new VersionResolverFactory(system, session, MavenProxyHandler::addProxySettings);
        }
        this.channelSession = this.initChannelSession(session, factory);
        if (restoreManifest.isPresent()) {
            ManifestVersionRecord manifestVersions = new ManifestVersionRecord("1.0.0", builder.restoredManifestVersions, Collections.emptyList(), Collections.emptyList());
            GalleonEnvironment.storeOriginalChannelManifestAsResolved(builder, factory, manifestVersions.getMavenManifests());
        }
        this.repositoryManager = builder.artifactDirectResolve ? new MavenArtifactDirectResolverRepositoryManager(this.channelSession) : (restoreManifest.isEmpty() ? new ChannelMavenArtifactRepositoryManager(this.channelSession) : new ChannelMavenArtifactRepositoryManager(this.channelSession, restoreManifest.get()));
        if (System.getProperty("galleon.config.use_linux_line_endings") == null) {
            System.setProperty("galleon.config.use_linux_line_endings", "true");
        } else {
            this.resetGalleonLineEndings = false;
        }
        GalleonBuilder provider = GalleonUtils.newGalleonBuilder(this.repositoryManager, builder.fpTracker);
        this.provisioning = GalleonUtils.newProvisioning(provider, builder.installDir, builder.config, PathsUtils.getProvisioningXml(builder.installDir), builder.useDefaultCore);
        Stream.of("LAYOUT_BUILD", "PACKAGES", "CONFIGS", TRACK_JBMODULES, TRACK_JBEXAMPLES).forEach(t -> this.provisioning.setProgressCallback((String)t, new GalleonCallbackAdapter(console.orElse(null), (String)t)));
        DownloadsCallbackAdapter callback = new DownloadsCallbackAdapter(console.orElse(null));
        session.setTransferListener(callback);
        this.provisioning.setProgressCallback(TRACK_JB_ARTIFACTS_RESOLVE, callback);
    }

    private static void storeOriginalChannelManifestAsResolved(Builder builder, MavenVersionsResolver.Factory factory, List<ManifestVersionRecord.MavenManifest> mavenManifests) {
        try (ChannelSession tempSession = new ChannelSession(builder.channels, factory);){
            for (ManifestVersionRecord.MavenManifest mavenManifest : mavenManifests) {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.tracef("Trying to resolve %s.", (Object)mavenManifest);
                    }
                    tempSession.resolveDirectMavenArtifact(mavenManifest.getGroupId(), mavenManifest.getArtifactId(), "yaml", "manifest", mavenManifest.getVersion());
                }
                catch (ArtifactTransferException e) {
                    ProsperoLogger.ROOT_LOGGER.debugf((Throwable)e, "Unable to resolve manifest %s:%s:%s for maven cache", (Object)mavenManifest.getGroupId(), (Object)mavenManifest.getArtifactId(), (Object)mavenManifest.getVersion());
                }
            }
        }
        catch (ArtifactTransferException e) {
            LOG.debug((Object)"Unable to resolve restored manifest", e);
        }
    }

    private List<Channel> replaceManifestWithRestoreManifests(Builder builder, Optional<ChannelManifest> restoreManifest) throws ProvisioningException {
        ChannelManifestCoordinate manifestCoord;
        try {
            this.restoreManifestPath = Files.createTempFile("prospero-restore-manifest", "yaml", new FileAttribute[0]);
            this.restoreManifestPath.toFile().deleteOnExit();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Created temporary restore manifest file at %s", (Object)this.restoreManifestPath);
            }
            Files.writeString(this.restoreManifestPath, (CharSequence)ChannelManifestMapper.toYaml(restoreManifest.get()), new OpenOption[0]);
            manifestCoord = new ChannelManifestCoordinate(this.restoreManifestPath.toUri().toURL());
        }
        catch (IOException e) {
            throw ProsperoLogger.ROOT_LOGGER.unableToCreateTemporaryFile(e);
        }
        List<Channel> channels = builder.channels.stream().map(c -> new Channel(c.getSchemaVersion(), c.getName(), c.getDescription(), c.getVendor(), c.getRepositories(), manifestCoord, c.getBlocklistCoordinate(), c.getNoStreamStrategy())).collect(Collectors.toList());
        return channels;
    }

    private ChannelSession initChannelSession(DefaultRepositorySystemSession session, MavenVersionsResolver.Factory factory) throws UnresolvedChannelMetadataException, ChannelDefinitionException {
        ChannelSession channelSession;
        try {
            channelSession = new ChannelSession(this.channels, factory);
        }
        catch (UnresolvedMavenArtifactException e) {
            Set<ChannelMetadataCoordinate> missingArtifacts = e.getUnresolvedArtifacts().stream().map(a -> new ChannelMetadataCoordinate(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), a.getExtension())).collect(Collectors.toSet());
            throw new UnresolvedChannelMetadataException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, missingArtifacts, e.getAttemptedRepositories(), session.isOffline());
        }
        catch (InvalidChannelMetadataException e) {
            if (e.getCause() instanceof FileNotFoundException) {
                String url = e.getValidationMessages().get(0);
                try {
                    ChannelMetadataCoordinate coord = new ChannelMetadataCoordinate(new URL(url));
                    throw new UnresolvedChannelMetadataException(ProsperoLogger.ROOT_LOGGER.unableToResolve(), e, Set.of(coord), Collections.emptySet(), session.isOffline());
                }
                catch (MalformedURLException ex) {
                    throw ProsperoLogger.ROOT_LOGGER.invalidManifest(e);
                }
            }
            throw ProsperoLogger.ROOT_LOGGER.invalidManifest(e);
        }
        return channelSession;
    }

    public Provisioning getProvisioning() {
        return this.provisioning;
    }

    public ChannelSession getChannelSession() {
        return this.channelSession;
    }

    public MavenRepoManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    @Override
    public void close() {
        if (this.resetGalleonLineEndings) {
            System.clearProperty("galleon.config.use_linux_line_endings");
        }
        if (this.restoreManifestPath != null) {
            FileUtils.deleteQuietly(this.restoreManifestPath.toFile());
        }
        this.provisioning.close();
    }

    public static Builder builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager, boolean useDefaultCore) {
        Objects.requireNonNull(installDir);
        Objects.requireNonNull(channels);
        Objects.requireNonNull(mavenSessionManager);
        return new Builder(installDir, channels, mavenSessionManager, useDefaultCore);
    }

    public static class Builder {
        private final Path installDir;
        private final List<Channel> channels;
        private final MavenSessionManager mavenSessionManager;
        private Console console;
        private ChannelManifest manifest;
        private Consumer<String> fpTracker;
        private Path sourceServerPath;
        private boolean artifactDirectResolve;
        private List<ManifestVersionRecord.MavenManifest> restoredManifestVersions;
        private final boolean useDefaultCore;
        private GalleonProvisioningConfig config;

        private Builder(Path installDir, List<Channel> channels, MavenSessionManager mavenSessionManager, boolean useDefaultCore) {
            this.installDir = installDir;
            this.channels = channels;
            this.mavenSessionManager = mavenSessionManager;
            this.useDefaultCore = useDefaultCore;
        }

        public Builder setConsole(Console console) {
            this.console = console;
            return this;
        }

        public Builder setProvisioningConfig(GalleonProvisioningConfig config) {
            this.config = config;
            return this;
        }

        public Builder setRestoreManifest(ChannelManifest manifest) {
            this.manifest = manifest;
            return this;
        }

        public Builder setRestoreManifest(ChannelManifest manifest, ManifestVersionRecord manifestVersions) {
            this.restoredManifestVersions = manifestVersions == null ? Collections.emptyList() : manifestVersions.getMavenManifests();
            return this.setRestoreManifest(manifest);
        }

        public Builder setResolvedFpTracker(Consumer<String> fpTracker) {
            this.fpTracker = fpTracker;
            return this;
        }

        public GalleonEnvironment build() throws ProvisioningException, OperationException {
            return new GalleonEnvironment(this);
        }

        public Builder setSourceServerPath(Path sourceServerPath) {
            this.sourceServerPath = sourceServerPath;
            return this;
        }

        public Builder setArtifactDirectResolve(boolean artifactDirectResolve) {
            this.artifactDirectResolve = artifactDirectResolve;
            return this;
        }

        public Path getSourceServerPath() {
            return this.sourceServerPath;
        }
    }
}

