/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.wildfly.channel.Channel;

public class InstallationProfile {
    private final String name;
    private final List<Channel> channels;
    private final URI galleonConfiguration;

    @JsonCreator
    public InstallationProfile(@JsonProperty(value="name") String name, @JsonProperty(value="channels") List<Channel> channels, @JsonProperty(value="galleonConfiguration") URI galleonConfiguration) {
        this.name = name;
        this.channels = channels;
        this.galleonConfiguration = galleonConfiguration;
    }

    public static void write(List<InstallationProfile> packs, File configFile) throws IOException {
        new ObjectMapper(new YAMLFactory()).writeValue(configFile, packs);
    }

    public static List<InstallationProfile> readConfig(URL url) throws IOException {
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper objectMapper = new ObjectMapper(yamlFactory);
        return objectMapper.readValue(url, new TypeReference<List<InstallationProfile>>(){});
    }

    public String getName() {
        return this.name;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public URI getGalleonConfiguration() {
        return this.galleonConfiguration;
    }

    public String toString() {
        return "InstallationProfile{name='" + this.name + "', channels=" + String.valueOf(this.channels) + ", galleonConfiguration=" + String.valueOf(this.galleonConfiguration) + "}";
    }
}

