/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonMetaSchemaFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.JsonSchemaVersion;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationMessage;
import java.util.Map;

public class DefaultJsonMetaSchemaFactory
implements JsonMetaSchemaFactory {
    @Override
    public JsonMetaSchema getMetaSchema(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        return SpecVersionDetector.detectOptionalVersion(iri).map(JsonSchemaFactory::checkVersion).map(JsonSchemaVersion::getInstance).orElseGet(() -> this.loadMetaSchema(iri, schemaFactory, config));
    }

    protected JsonMetaSchema loadMetaSchema(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        try {
            JsonMetaSchema result = this.loadMetaSchemaBuilder(iri, schemaFactory, config).build();
            return result;
        }
        catch (InvalidSchemaException e) {
            throw e;
        }
        catch (Exception e) {
            ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().message("Failed to load meta-schema ''{1}''")).arguments(iri)).build();
            throw new InvalidSchemaException(validationMessage, e);
        }
    }

    protected JsonMetaSchema.Builder loadMetaSchemaBuilder(String iri, JsonSchemaFactory schemaFactory, SchemaValidatorsConfig config) {
        JsonNode vocabulary;
        JsonSchema schema = schemaFactory.getSchema(SchemaLocation.of(iri), config);
        JsonMetaSchema.Builder builder = JsonMetaSchema.builder(iri, schema.getValidationContext().getMetaSchema());
        SpecVersion.VersionFlag specification = schema.getValidationContext().getMetaSchema().getSpecification();
        if (specification != null && specification.getVersionFlagValue() >= SpecVersion.VersionFlag.V201909.getVersionFlagValue() && (vocabulary = schema.getSchemaNode().get("$vocabulary")) != null) {
            builder.vocabularies(Map::clear);
            for (Map.Entry<String, JsonNode> vocabs : vocabulary.properties()) {
                builder.vocabulary(vocabs.getKey(), vocabs.getValue().booleanValue());
            }
        }
        return builder;
    }

    public static DefaultJsonMetaSchemaFactory getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final DefaultJsonMetaSchemaFactory INSTANCE = new DefaultJsonMetaSchemaFactory();

        private Holder() {
        }
    }
}

