/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.BundlePlan;
import org.osgi.framework.Bundle;

public class SisuBundlePlan
implements BundlePlan {
    protected final MutableBeanLocator locator;

    public SisuBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle2) {
        return this.appliesTo(bundle2) ? InjectorBindings.findBindingPublisher(this.inject(this.compose(bundle2))) : null;
    }

    protected boolean appliesTo(Bundle bundle2) {
        if (bundle2.getHeaders().get("Bundle-Blueprint") != null) {
            return false;
        }
        String imports = (String)bundle2.getHeaders().get("Import-Package");
        return null != imports && (imports.contains("javax.inject") || imports.contains("com.google.inject"));
    }

    protected Injector inject(Module module) {
        return Guice.createInjector((Module[])new Module[]{module});
    }

    protected Module compose(Bundle bundle2) {
        return new BundleModule(bundle2, this.locator);
    }
}

