/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.spi;

import java.nio.file.Path;
import org.wildfly.installationmanager.spi.OsShell;
import org.wildfly.prospero.DistributionInfo;
import org.wildfly.prospero.spi.internal.CliProvider;

public class CliProviderImpl
implements CliProvider {
    @Override
    public String getScriptName(OsShell shell) {
        return DistributionInfo.DIST_NAME + (switch (shell) {
            case OsShell.Linux -> ".sh";
            case OsShell.WindowsBash -> ".bat";
            case OsShell.WindowsPowerShell -> ".ps1";
            default -> throw new IllegalArgumentException(String.format("The requested shell %s is not supported", new Object[]{shell}));
        });
    }

    @Override
    public String getApplyUpdateCommand(Path installationPath, Path candidatePath, boolean noConflictsOnly) {
        return "update apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes " + (noConflictsOnly ? "--no-conflicts-only " : "") + "--rm";
    }

    @Override
    public String getApplyRevertCommand(Path installationPath, Path candidatePath, boolean noConflictsOnly) {
        return "revert apply --dir " + this.escape(installationPath.toAbsolutePath()) + " --candidate-dir " + this.escape(candidatePath.toAbsolutePath()) + " --yes " + (noConflictsOnly ? "--no-conflicts-only " : "") + "--rm";
    }

    private String escape(Path absolutePath) {
        return "\"" + absolutePath.toString() + "\"";
    }
}

