/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli;

import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.cli.CliMessages;
import picocli.CommandLine;

class UnknownCommandParameterExceptionHandler
implements CommandLine.IParameterExceptionHandler {
    protected static final String COMMAND_SEPARATOR = " ";
    private final CommandLine.IParameterExceptionHandler delegate;
    private final PrintStream writer;
    private final boolean isVerbose;

    @Deprecated(forRemoval=true)
    public UnknownCommandParameterExceptionHandler(CommandLine.IParameterExceptionHandler delegate, PrintStream writer) {
        this(delegate, writer, false);
    }

    public UnknownCommandParameterExceptionHandler(CommandLine.IParameterExceptionHandler delegate, PrintStream writer, boolean isVerbose) {
        this.delegate = delegate;
        this.writer = writer;
        this.isVerbose = isVerbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleParseException(CommandLine.ParameterException ex, String[] args) throws Exception {
        try {
            if (ex instanceof CommandLine.UnmatchedArgumentException) {
                CommandLine.UnmatchedArgumentException argEx = (CommandLine.UnmatchedArgumentException)ex;
                if (argEx.isUnknownOption()) {
                    int n = this.delegate.handleParseException(ex, args);
                    return n;
                }
                if (!UnknownCommandParameterExceptionHandler.currentCommandHasSubcommands(argEx)) {
                    int n = this.delegate.handleParseException(ex, args);
                    return n;
                }
                CommandLine.Help.ColorScheme colorScheme = CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.AUTO);
                String commandName = argEx.getCommandLine().getCommandSpec().name();
                String fullCommand = commandName + COMMAND_SEPARATOR + StringUtils.join((Iterable)argEx.getUnmatched(), (String)COMMAND_SEPARATOR);
                this.writer.println(colorScheme.errorText(CliMessages.MESSAGES.unknownCommand(fullCommand)));
                List suggestions = argEx.getSuggestions();
                if (suggestions.isEmpty()) {
                    argEx.getCommandLine().usage(this.writer);
                } else {
                    this.writer.printf(CliMessages.MESSAGES.commandSuggestions(this.prefix(commandName, suggestions)), new Object[0]);
                }
                int n = 2;
                return n;
            }
            int n = this.delegate.handleParseException(ex, args);
            return n;
        }
        finally {
            ProsperoLogger.ROOT_LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            if (this.isVerbose) {
                this.writer.println();
                ex.printStackTrace(this.writer);
            }
        }
    }

    private static boolean currentCommandHasSubcommands(CommandLine.UnmatchedArgumentException argEx) {
        return !argEx.getCommandLine().getParseResult().commandSpec().subcommands().isEmpty();
    }

    private List<String> prefix(String commandName, List<String> commandSuggestions) {
        return commandSuggestions.stream().map(s -> commandName + COMMAND_SEPARATOR + s).collect(Collectors.toList());
    }
}

