/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.cli.commands;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.api.ProvisioningDefinition;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.TemporaryFilesManager;
import org.wildfly.prospero.api.exceptions.InvalidRepositoryArchiveException;
import org.wildfly.prospero.cli.ActionFactory;
import org.wildfly.prospero.cli.ArgumentParsingException;
import org.wildfly.prospero.cli.CliConsole;
import org.wildfly.prospero.cli.RepositoryDefinition;
import org.wildfly.prospero.cli.commands.AbstractCommand;
import org.wildfly.prospero.cli.commands.InstallCommand;
import org.wildfly.prospero.cli.commands.options.LocalRepoOptions;
import picocli.CommandLine;

public abstract class AbstractInstallCommand
extends AbstractCommand {
    @CommandLine.ArgGroup(heading="%nInstallation source:%n", exclusive=true, multiplicity="1", order=1)
    InstallCommand.FeaturePackOrDefinition featurePackOrDefinition;
    @CommandLine.Option(names={"--channels", "--channel"}, paramLabel="<channel-reference>", order=2, split=",")
    List<String> channelCoordinates = new ArrayList<String>();
    @CommandLine.Option(names={"--manifest"}, paramLabel="<manifest-reference>", split=",", order=3)
    List<String> manifestCoordinates = Collections.emptyList();
    @CommandLine.Option(names={"--repositories"}, paramLabel="<repo-url>", split=",", order=4)
    List<String> remoteRepositories = new ArrayList<String>();
    @CommandLine.ArgGroup(exclusive=true, order=5, headingKey="localRepoOptions.heading")
    LocalRepoOptions localRepoOptions = new LocalRepoOptions();
    @CommandLine.Option(names={"--offline"}, order=6)
    Optional<Boolean> offline = Optional.empty();

    public AbstractInstallCommand(CliConsole console, ActionFactory actionFactory) {
        super(console, actionFactory);
    }

    protected MavenOptions getMavenOptions() throws ArgumentParsingException {
        MavenOptions.Builder mavenOptions = this.localRepoOptions.toOptions();
        this.offline.map(arg_0 -> ((MavenOptions.Builder)mavenOptions).setOffline(arg_0));
        return mavenOptions.build();
    }

    protected ProvisioningDefinition.Builder buildDefinition(TemporaryFilesManager temporaryFiles) throws ArgumentParsingException, InvalidRepositoryArchiveException {
        List repositories = RepositoryUtils.unzipArchives(RepositoryDefinition.from(this.remoteRepositories), (TemporaryFilesManager)temporaryFiles);
        return ProvisioningDefinition.builder().setFpl((String)this.featurePackOrDefinition.fpl.orElse(null)).setProfile((String)this.featurePackOrDefinition.profile.orElse(null)).setManifests(this.manifestCoordinates).setChannelCoordinates(this.channelCoordinates).setOverrideRepositories(repositories).setDefinitionFile((URI)this.featurePackOrDefinition.definition.map(Path::toUri).orElse(null));
    }
}

