/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.exceptions.ArtifactPromoteException;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.NoChannelException;
import org.wildfly.prospero.api.exceptions.ProvisioningRuntimeException;

public class Messages_$bundle
implements Messages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected Messages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String dirMustBeDirectory$str() {
        return "Given path '%s' is a regular file. An empty directory or a non-existing path must be given.";
    }

    @Override
    public final IllegalArgumentException dirMustBeDirectory(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.dirMustBeDirectory$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotInstallIntoNonEmptyDirectory$str() {
        return "Can't install into a non empty directory '%s'. Use `update` command if you want to modify existing installation.";
    }

    @Override
    public final IllegalArgumentException cannotInstallIntoNonEmptyDirectory(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotInstallIntoNonEmptyDirectory$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationDirDoesNotExist$str() {
        return "Installation dir '%s' doesn't exist";
    }

    @Override
    public final IllegalArgumentException installationDirDoesNotExist(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.installationDirDoesNotExist$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationDirAlreadyExists$str() {
        return "Installation dir '%s' already exists";
    }

    @Override
    public final ProvisioningException installationDirAlreadyExists(Path installDir) {
        ProvisioningException result = new ProvisioningException(String.format(this.getLoggingLocale(), this.installationDirAlreadyExists$str(), installDir));
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String artifactNotFound$str() {
        return "Artifact [%s:%s] not found";
    }

    @Override
    public final ArtifactResolutionException artifactNotFound(String g, String a, UnresolvedMavenArtifactException e) {
        ArtifactResolutionException result = new ArtifactResolutionException(String.format(this.getLoggingLocale(), this.artifactNotFound$str(), g, a), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noChannelReference$str() {
        return "Given configuration doesn't reference any channel or channel manifest.";
    }

    @Override
    public final NoChannelException noChannelReference() {
        NoChannelException result = new NoChannelException(String.format(this.getLoggingLocale(), this.noChannelReference$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noChannelManifestReference$str() {
        return "Invalid channel: Channel '%s' doesn't reference a manifest.";
    }

    @Override
    public final NoChannelException noChannelManifestReference(String name) {
        NoChannelException result = new NoChannelException(String.format(this.getLoggingLocale(), this.noChannelManifestReference$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fplDefinitionDoesntContainChannel$str() {
        return "Pre-defined FPL [%s] doesn't specify any channels and no explicit channels were given.";
    }

    @Override
    public final NoChannelException fplDefinitionDoesntContainChannel(String fpl) {
        NoChannelException result = new NoChannelException(String.format(this.getLoggingLocale(), this.fplDefinitionDoesntContainChannel$str(), fpl));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelExists$str() {
        return "Channel '%s' is already present.";
    }

    @Override
    public final MetadataException channelExists(String channelName) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.channelExists$str(), channelName));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String channelNotFound$str() {
        return "Channel with name [%s] cannot be found.";
    }

    @Override
    public final MetadataException channelNotFound(String channelName) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.channelNotFound$str(), channelName));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyChannelName$str() {
        return "Channel name cannot be empty.";
    }

    @Override
    public final MetadataException emptyChannelName() {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.emptyChannelName$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String promotingArtifacts$str() {
        return "Promoting artifacts to %s:";
    }

    @Override
    public final String promotingArtifacts(URL targetRepository) {
        return String.format(this.getLoggingLocale(), this.promotingArtifacts$str(), targetRepository);
    }

    protected String invalidFpl$str() {
        return "Provided FPL has invalid format `%s`.";
    }

    @Override
    public final String invalidFpl(String fplText) {
        return String.format(this.getLoggingLocale(), this.invalidFpl$str(), fplText);
    }

    protected String unableToParseConfiguration$str() {
        return "Unable to parse server configuration at '%s'";
    }

    @Override
    public final MetadataException unableToParseConfiguration(Path path, Throwable e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToParseConfiguration$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseConfigurationUri$str() {
        return "Unable to parse server configuration at '%s'";
    }

    @Override
    public final MetadataException unableToParseConfigurationUri(URI uri, Throwable e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToParseConfigurationUri$str(), uri), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToSaveConfiguration$str() {
        return "Unable to save server configuration at '%s'";
    }

    @Override
    public final MetadataException unableToSaveConfiguration(Path path, Exception e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToSaveConfiguration$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCloseStore$str() {
        return "Unable to close the update store.";
    }

    @Override
    public final MetadataException unableToCloseStore(Exception e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToCloseStore$str(), new Object[0]), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidInstallationDir$str() {
        return "Path `%s` does not contain a server installation provisioned by prospero.";
    }

    @Override
    public final IllegalArgumentException invalidInstallationDir(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidInstallationDir$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateHistoryStorage$str() {
        return "Unable to create history store at [%s]";
    }

    @Override
    public final MetadataException unableToCreateHistoryStorage(Path path, Exception e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToCreateHistoryStorage$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToAccessHistoryStorage$str() {
        return "Unable to access history store at [%s]";
    }

    @Override
    public final MetadataException unableToAccessHistoryStorage(Path path, Exception e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToAccessHistoryStorage$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToReadFile$str() {
        return "Unable to read file at [%s]";
    }

    @Override
    public final MetadataException unableToReadFile(Path path, Exception e) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.unableToReadFile$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateCache$str() {
        return "Unable to create temporary cache for provisioning cache folder.";
    }

    @Override
    public final ProvisioningException unableToCreateCache(Exception e) {
        ProvisioningException result = new ProvisioningException(String.format(this.getLoggingLocale(), this.unableToCreateCache$str(), new Object[0]), (Throwable)e);
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToInitMaven$str() {
        return "Failed to initiate maven repository system";
    }

    @Override
    public final ProvisioningRuntimeException failedToInitMaven(Throwable exception) {
        ProvisioningRuntimeException result = new ProvisioningRuntimeException(String.format(this.getLoggingLocale(), this.failedToInitMaven$str(), new Object[0]));
        result.initCause(exception);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUrl$str() {
        return "Invalide URL [%s]";
    }

    @Override
    public final IllegalArgumentException invalidUrl(String text, Exception e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidUrl$str(), text), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String predefinedFplOrChannelRequired$str() {
        return "Incomplete configuration: If the FPL is not one of predefined names (%s) a channel must be given.";
    }

    @Override
    public final IllegalArgumentException predefinedFplOrChannelRequired(String availableFpls) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.predefinedFplOrChannelRequired$str(), availableFpls));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String fplNorGalleonConfigWereSet$str() {
        return "Incomplete configuration: neither FPL nor Galleon provisioning config was given.";
    }

    @Override
    public final IllegalArgumentException fplNorGalleonConfigWereSet() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.fplNorGalleonConfigWereSet$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompleteMetadataBundle$str() {
        return "Provided metadata bundle [%s] is missing one or more entries";
    }

    @Override
    public final IllegalArgumentException incompleteMetadataBundle(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incompleteMetadataBundle$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedArtifact$str() {
        return "Found unexpected artifact [%s]";
    }

    @Override
    public final ProvisioningRuntimeException unexpectedArtifact(String gav) {
        ProvisioningRuntimeException result = new ProvisioningRuntimeException(String.format(this.getLoggingLocale(), this.unexpectedArtifact$str(), gav));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToResolve$str() {
        return "Unable to resolve [%s]";
    }

    @Override
    public final MavenUniverseException unableToResolve(String gav) {
        MavenUniverseException result = new MavenUniverseException(String.format(this.getLoggingLocale(), this.unableToResolve$str(), gav));
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String fileAlreadyExists$str() {
        return "File already exists [%s]";
    }

    @Override
    public final IllegalArgumentException fileAlreadyExists(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.fileAlreadyExists$str(), path));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedPromotionTarget$str() {
        return "Promoting to non-file repositories is not currently supported";
    }

    @Override
    public final IllegalArgumentException unsupportedPromotionTarget() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unsupportedPromotionTarget$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wrongVersionFormat$str() {
        return "Wrong format of custom channel version [%s]";
    }

    @Override
    public final IllegalArgumentException wrongVersionFormat(String baseVersion) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.wrongVersionFormat$str(), baseVersion));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String versionLimitExceeded$str() {
        return "Custom channel version exceeded limit [%s]";
    }

    @Override
    public final IllegalArgumentException versionLimitExceeded(String baseVersion) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.versionLimitExceeded$str(), baseVersion));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noArtifactsToPackage$str() {
        return "Cannot create bundle without artifacts.";
    }

    @Override
    public final IllegalArgumentException noArtifactsToPackage() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noArtifactsToPackage$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonMavenChannelRef$str() {
        return "Channel reference has to use Maven GA.";
    }

    @Override
    public final IllegalArgumentException nonMavenChannelRef() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nonMavenChannelRef$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToPromote$str() {
        return "Unable to promote artifacts to [%s].";
    }

    @Override
    public final ArtifactPromoteException unableToPromote(URL target, Exception e) {
        ArtifactPromoteException result = new ArtifactPromoteException(String.format(this.getLoggingLocale(), this.unableToPromote$str(), target), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseCustomizationBundle$str() {
        return "Unable to parse the customization bundle [%s].";
    }

    @Override
    public final ArtifactPromoteException unableToParseCustomizationBundle(Path path, Exception e) {
        ArtifactPromoteException result = new ArtifactPromoteException(String.format(this.getLoggingLocale(), this.unableToParseCustomizationBundle$str(), path), e);
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String repositoriesMustBeSetWithManifest$str() {
        return "At least one repository must be set when using the manifest option.";
    }

    @Override
    public final IllegalArgumentException repositoriesMustBeSetWithManifest() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.repositoriesMustBeSetWithManifest$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outFileExists$str() {
        return "Out file [%s] exists already!";
    }

    @Override
    public final IllegalArgumentException outFileExists(Path outPath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.outFileExists$str(), outPath));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String installationExported$str() {
        return "Installation metadata is exported to [%s].";
    }

    @Override
    public final String installationExported(Path outPath) {
        return String.format(this.getLoggingLocale(), this.installationExported$str(), outPath);
    }

    protected String restoreFileNotExisted$str() {
        return "The file: [%s] to be restored does not exist.";
    }

    @Override
    public final String restoreFileNotExisted(Path path) {
        return String.format(this.getLoggingLocale(), this.restoreFileNotExisted$str(), path);
    }

    protected String installationMetaRestored$str() {
        return "Installation meta was restored from: [%s] to [%s].";
    }

    @Override
    public final String installationMetaRestored(Path restorePath, Path installPath) {
        return String.format(this.getLoggingLocale(), this.installationMetaRestored$str(), restorePath, installPath);
    }

    protected String invalidPropertySubstitutionValue$str() {
        return "Malformed URL in substituted value : %s from %s";
    }

    @Override
    public final MetadataException invalidPropertySubstitutionValue(String substituted, String url) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.invalidPropertySubstitutionValue$str(), substituted, url));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUpdateCandidate$str() {
        return "The installation at %s is not a valid update for %s";
    }

    @Override
    public final InvalidUpdateCandidateException invalidUpdateCandidate(Path update, Path installation) {
        InvalidUpdateCandidateException result = new InvalidUpdateCandidateException(String.format(this.getLoggingLocale(), this.invalidUpdateCandidate$str(), update, installation));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String savedStateNotFound$str() {
        return "The requested state %s does not exist in server's history.";
    }

    @Override
    public final MetadataException savedStateNotFound(String name) {
        MetadataException result = new MetadataException(String.format(this.getLoggingLocale(), this.savedStateNotFound$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateTemporaryDirectory$str() {
        return "Unable to create temporary directory";
    }

    @Override
    public final ProvisioningException unableToCreateTemporaryDirectory(Throwable t) {
        ProvisioningException result = new ProvisioningException(String.format(this.getLoggingLocale(), this.unableToCreateTemporaryDirectory$str(), new Object[0]), t);
        Messages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

