/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.diff.FsEntry;
import org.jboss.galleon.layout.SystemPaths;
import org.jboss.galleon.util.HashUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.logging.Logger;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.FileConflict;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.exceptions.InvalidUpdateCandidateException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ArtifactCache;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.installation.git.GitStorage;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ApplyCandidateAction {
    public static final Path UPDATE_MARKER_FILE = Path.of(".installation", ".update.txt");
    private static final Logger LOGGER = Logger.getLogger(ApplyCandidateAction.class);
    public static final Path STANDALONE_STARTUP_MARKER = Path.of("standalone", "tmp", "startup-marker");
    public static final Path DOMAIN_STARTUP_MARKER = Path.of("domain", "tmp", "startup-marker");
    private final Path updateDir;
    private final Path installationDir;
    private final SystemPaths systemPaths;
    private final ProvisioningManager provisioningManager;

    public ApplyCandidateAction(Path installationDir, Path updateDir) throws ProvisioningException, OperationException {
        this.updateDir = updateDir;
        this.installationDir = installationDir;
        try {
            this.systemPaths = SystemPaths.load((Path)updateDir);
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("System paths " + this.systemPaths.getPaths()));
        }
        this.provisioningManager = GalleonEnvironment.builder(installationDir, Collections.emptyList(), new MavenSessionManager(Optional.empty(), true)).build().getProvisioningManager();
    }

    public List<FileConflict> applyUpdate() throws ProvisioningException, InvalidUpdateCandidateException, MetadataException {
        if (!this.verifyUpdateCandidate()) {
            throw Messages.MESSAGES.invalidUpdateCandidate(this.updateDir, this.installationDir);
        }
        if (this.targetServerIsRunning()) {
            throw new ProvisioningException("The server appears to be running.");
        }
        FsDiff diffs = this.findChanges();
        try {
            List<FileConflict> conflicts = this.doApplyUpdate(diffs);
            this.updateMetadata();
            return conflicts;
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    public boolean verifyUpdateCandidate() throws InvalidUpdateCandidateException, MetadataException {
        Path updateMarkerPath = this.updateDir.resolve(UPDATE_MARKER_FILE);
        if (!Files.exists(updateMarkerPath, new LinkOption[0])) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("The update candidate [%s] doesn't have a marker file", (Object)this.updateDir);
            }
            throw Messages.MESSAGES.invalidUpdateCandidate(this.updateDir, this.installationDir);
        }
        try {
            String hash = Files.readString(updateMarkerPath);
            if (!new InstallationMetadata(this.installationDir).getRevisions().get(0).getName().equals(hash)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("The installation state has changed from the update candidate [%s].", (Object)this.updateDir);
                }
                return false;
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debugf("Unable to read marker file [%s].", (Object)this.updateDir);
            }
            throw Messages.MESSAGES.unableToReadFile(updateMarkerPath, e);
        }
        return true;
    }

    private boolean targetServerIsRunning() {
        return Files.exists(this.installationDir.resolve(STANDALONE_STARTUP_MARKER), new LinkOption[0]) || Files.exists(this.installationDir.resolve(DOMAIN_STARTUP_MARKER), new LinkOption[0]);
    }

    private FsDiff findChanges() throws ProvisioningException {
        return this.provisioningManager.getFsDiff();
    }

    private void updateMetadata() throws ProvisioningException, MetadataException {
        try {
            this.writeProsperoMetadata();
            this.updateInstallationCache();
            Path installationGalleonPath = PathsUtils.getProvisionedStateDir((Path)this.installationDir);
            Path updateGalleonPath = PathsUtils.getProvisionedStateDir((Path)this.updateDir);
            IoUtils.recursiveDelete((Path)installationGalleonPath);
            IoUtils.copy((Path)updateGalleonPath, (Path)installationGalleonPath, (boolean)true);
        }
        catch (IOException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProsperoMetadata() throws MetadataException, IOException {
        Path updateMetadataDir = this.updateDir.resolve(".installation");
        Path updateManifest = updateMetadataDir.resolve("manifest.yaml");
        Path installationMetadataDir = this.installationDir.resolve(".installation");
        Path installationManifest = installationMetadataDir.resolve("manifest.yaml");
        IoUtils.copy((Path)updateManifest, (Path)installationManifest);
        GitStorage git = new GitStorage(this.installationDir);
        try {
            git.record();
        }
        finally {
            try {
                git.close();
            }
            catch (Exception e) {
                Messages.MESSAGES.unableToCloseStore(e);
            }
        }
    }

    private void updateInstallationCache() throws IOException {
        Path updateCacheDir = this.updateDir.resolve(ArtifactCache.CACHE_FOLDER);
        Path installationCacheDir = this.installationDir.resolve(ArtifactCache.CACHE_FOLDER);
        if (Files.exists(installationCacheDir, new LinkOption[0])) {
            IoUtils.recursiveDelete((Path)installationCacheDir);
        }
        if (Files.exists(updateCacheDir, new LinkOption[0])) {
            IoUtils.copy((Path)updateCacheDir, (Path)installationCacheDir);
        }
    }

    private List<FileConflict> handleRemovedFiles(FsDiff fsDiff) throws IOException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasRemovedEntries()) {
            for (FsEntry removed : fsDiff.getRemovedEntries()) {
                Path target = this.updateDir.resolve(removed.getRelativePath());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'-', (String)removed.getRelativePath(), null));
                }
                if (Files.exists(target, new LinkOption[0])) {
                    if (!this.systemPaths.isSystemPath(Paths.get(removed.getRelativePath(), new String[0]))) continue;
                    conflictList.add(FileConflict.userRemoved(removed.getRelativePath()).updateModified().overwritten());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)FsDiff.formatMessage((char)'F', (String)removed.getRelativePath(), (String)"has changed in the updated version"));
                    }
                    Files.createDirectories(this.installationDir.resolve(removed.getRelativePath()).getParent(), new FileAttribute[0]);
                    IoUtils.copy((Path)target, (Path)this.installationDir.resolve(removed.getRelativePath()));
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)FsDiff.formatMessage((char)'-', (String)removed.getRelativePath(), (String)"has been removed from the updated version"));
            }
        }
        return conflictList;
    }

    private List<FileConflict> handleAddedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasAddedEntries()) {
            for (FsEntry added : fsDiff.getAddedEntries()) {
                Path p = Paths.get(added.getRelativePath(), new String[0]);
                if (p.getNameCount() > 0 && p.getName(0).toString().equals(".installation")) continue;
                this.addFsEntry(this.updateDir, added, this.systemPaths, conflictList);
            }
        }
        return conflictList;
    }

    private void addFsEntry(Path updateDir, FsEntry added, SystemPaths systemPaths, List<FileConflict> conflictList) throws ProvisioningException {
        Path target = updateDir.resolve(added.getRelativePath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)FsDiff.formatMessage((char)'+', (String)added.getRelativePath(), null));
        }
        if (Files.exists(target, new LinkOption[0])) {
            byte[] targetHash;
            if (added.isDir()) {
                for (FsEntry child : added.getChildren()) {
                    this.addFsEntry(updateDir, child, systemPaths, conflictList);
                }
                return;
            }
            try {
                targetHash = HashUtils.hashPath((Path)target);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.hashCalculation((Path)target), (Throwable)e);
            }
            if (Arrays.equals(added.getHash(), targetHash)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'+', (String)added.getRelativePath(), (String)"Added file matches the update."));
                }
            } else if (systemPaths.isSystemPath(Paths.get(added.getRelativePath(), new String[0]))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'F', (String)added.getRelativePath(), (String)"conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().overwritten());
                ApplyCandidateAction.glold(this.installationDir.resolve(added.getRelativePath()), target);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'C', (String)added.getRelativePath(), (String)"conflicts with the updated version"));
                }
                conflictList.add(FileConflict.userAdded(added.getRelativePath()).updateAdded().userPreserved());
                ApplyCandidateAction.glnew(target, this.installationDir.resolve(added.getRelativePath()));
            }
        }
    }

    private List<FileConflict> handleModifiedFiles(FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflictList = new ArrayList<FileConflict>();
        if (fsDiff.hasModifiedEntries()) {
            for (FsEntry[] modified : fsDiff.getModifiedEntries()) {
                FsEntry installation = modified[1];
                FsEntry original = modified[0];
                Path file = this.updateDir.resolve(modified[1].getRelativePath());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), null));
                }
                if (Files.exists(file, new LinkOption[0])) {
                    byte[] updateHash;
                    try {
                        updateHash = HashUtils.hashPath((Path)file);
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.hashCalculation((Path)file), (Throwable)e);
                    }
                    Path installationFile = this.installationDir.resolve(modified[1].getRelativePath());
                    if (Arrays.equals(installation.getHash(), updateHash)) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), (String)"Modified file matches the update"));
                        continue;
                    }
                    if (Arrays.equals(original.getHash(), updateHash)) continue;
                    if (this.systemPaths.isSystemPath(Paths.get(installation.getRelativePath(), new String[0]))) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)FsDiff.formatMessage((char)'F', (String)installation.getRelativePath(), (String)"has changed in the updated version"));
                        }
                        conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().overwritten());
                        ApplyCandidateAction.glold(installation.getPath(), file);
                        continue;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)FsDiff.formatMessage((char)'C', (String)installation.getRelativePath(), (String)"has changed in the updated version"));
                    }
                    conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateModified().userPreserved());
                    ApplyCandidateAction.glnew(file, installationFile);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)FsDiff.formatMessage((char)'M', (String)installation.getRelativePath(), (String)"has been removed from the updated version"));
                }
                conflictList.add(FileConflict.userModified(installation.getRelativePath()).updateRemoved().userPreserved());
            }
        }
        return conflictList;
    }

    private List<FileConflict> doApplyUpdate(final FsDiff fsDiff) throws IOException, ProvisioningException {
        ArrayList<FileConflict> conflicts = new ArrayList<FileConflict>();
        conflicts.addAll(this.handleRemovedFiles(fsDiff));
        conflicts.addAll(this.handleAddedFiles(fsDiff));
        conflicts.addAll(this.handleModifiedFiles(fsDiff));
        final Path skipUpdateGalleon = PathsUtils.getProvisionedStateDir((Path)this.updateDir);
        final Path skipUpdateInstallation = this.updateDir.resolve(".installation");
        final Path skipInstallationGalleon = PathsUtils.getProvisionedStateDir((Path)this.installationDir);
        final Path skipInstallationInstallation = this.installationDir.resolve(".installation");
        Files.walkFileTree(this.updateDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.updateDir.relativize(file);
                Path installationFile = ApplyCandidateAction.this.installationDir.resolve(relative);
                String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (fsDiff.getModifiedEntry(pathKey) == null && fsDiff.getAddedEntry(pathKey) == null && !this.isParentAdded(fsDiff, relative)) {
                    byte[] updateHash = HashUtils.hashPath((Path)file);
                    if (!Files.exists(installationFile, new LinkOption[0]) || !Arrays.equals(updateHash, HashUtils.hashPath((Path)installationFile))) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Copying updated file " + relative + " to the installation"));
                        }
                        IoUtils.copy((Path)file, (Path)installationFile);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private boolean isParentAdded(FsDiff fsDiff2, Path relative) {
                for (Path parent = relative.getParent(); parent != null; parent = parent.getParent()) {
                    if (fsDiff2.getAddedEntry(parent + "/") == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(skipUpdateGalleon) || dir.equals(skipUpdateInstallation)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Files.walkFileTree(this.installationDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relative = ApplyCandidateAction.this.installationDir.relativize(file);
                Path updateFile = ApplyCandidateAction.this.updateDir.resolve(relative);
                String fsDiffKey = ApplyCandidateAction.this.getFsDiffKey(relative, false);
                if (!(fsDiff.getAddedEntry(fsDiffKey) != null || fsDiff.getModifiedEntry(fsDiffKey) != null || Files.exists(updateFile, new LinkOption[0]) || updateFile.toString().endsWith(".glnew") || updateFile.toString().endsWith(".glold"))) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Deleting the file " + relative + " that doesn't exist in the update"));
                    }
                    IoUtils.recursiveDelete((Path)file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.equals(skipInstallationGalleon) || dir.equals(skipInstallationInstallation)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (fsDiff.getAddedEntry(pathKey) != null && !Files.exists(target, new LinkOption[0])) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("The directory " + relative + " that doesn't exist in the update is a User changes, skipping it"));
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (!dir.equals(ApplyCandidateAction.this.installationDir)) {
                    Path relative = ApplyCandidateAction.this.installationDir.relativize(dir);
                    Path target = ApplyCandidateAction.this.updateDir.resolve(relative);
                    String pathKey = ApplyCandidateAction.this.getFsDiffKey(relative, true);
                    if (fsDiff.getAddedEntry(pathKey) == null && !Files.exists(target, new LinkOption[0]) && dir.toFile().list().length == 0) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("Deleting the directory " + relative + " that doesn't exist in the update"));
                        }
                        IoUtils.recursiveDelete((Path)dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return Collections.unmodifiableList(conflicts);
    }

    private String getFsDiffKey(Path relative, boolean appendSeparator) {
        Object pathKey = relative.toString().replace(File.separator, "/");
        if (appendSeparator) {
            pathKey = ((String)pathKey).endsWith("/") ? pathKey : (String)pathKey + "/";
        }
        return pathKey;
    }

    private static void glnew(Path updateFile, Path installationFile) throws ProvisioningException {
        try {
            IoUtils.copy((Path)updateFile, (Path)installationFile.getParent().resolve(installationFile.getFileName() + ".glnew"));
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + installationFile.getParent().resolve(installationFile.getFileName() + ".glnew"), (Throwable)e);
        }
    }

    private static void glold(Path installationFile, Path target) throws ProvisioningException {
        try {
            IoUtils.copy((Path)installationFile, (Path)installationFile.getParent().resolve(installationFile.getFileName() + ".glold"));
            IoUtils.copy((Path)target, (Path)installationFile);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist " + target.getParent().resolve(target.getFileName() + ".glold"), (Throwable)e);
        }
    }
}

