/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Repository;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.Console;
import org.wildfly.prospero.actions.PrepareCandidateAction;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class InstallationHistoryAction {
    private final Path installation;
    private final Console console;

    public InstallationHistoryAction(Path installation, Console console) {
        this.installation = installation;
        this.console = console;
    }

    public InstallationChanges compare(SavedState savedState) throws MetadataException {
        InstallationMetadata installationMetadata = new InstallationMetadata(this.installation);
        InstallationHistoryAction.verifyStateExists(savedState, installationMetadata);
        return installationMetadata.getChangesSince(savedState);
    }

    public List<SavedState> getRevisions() throws MetadataException {
        InstallationMetadata installationMetadata = new InstallationMetadata(this.installation);
        return installationMetadata.getRevisions();
    }

    public void rollback(SavedState savedState, MavenSessionManager mavenSessionManager, List<Repository> overrideRepositories) throws OperationException, ProvisioningException {
        Path tempDirectory = null;
        try {
            tempDirectory = Files.createTempDirectory("eap-revert", new FileAttribute[0]);
            this.prepareRevert(savedState, mavenSessionManager, overrideRepositories, tempDirectory);
            new ApplyCandidateAction(this.installation, tempDirectory).applyUpdate();
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToCreateTemporaryDirectory(e);
        }
        finally {
            if (tempDirectory != null) {
                FileUtils.deleteQuietly((File)tempDirectory.toFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRevert(SavedState savedState, MavenSessionManager mavenSessionManager, List<Repository> overrideRepositories, Path targetDir) throws OperationException, ProvisioningException {
        try (InstallationMetadata metadata = new InstallationMetadata(this.installation);){
            InstallationHistoryAction.verifyStateExists(savedState, metadata);
            ProsperoConfig prosperoConfig = new ProsperoConfig(TemporaryRepositoriesHandler.overrideRepositories(metadata.getProsperoConfig().getChannels(), overrideRepositories));
            try (InstallationMetadata revertMetadata = metadata.rollback(savedState);){
                GalleonEnvironment galleonEnv = GalleonEnvironment.builder(targetDir, prosperoConfig.getChannels(), mavenSessionManager).setConsole(this.console).setRestoreManifest(revertMetadata.getManifest()).build();
                System.setProperty("maven.repo.local", mavenSessionManager.getProvisioningRepo().toAbsolutePath().toString());
                try (PrepareCandidateAction prepareCandidateAction = new PrepareCandidateAction(this.installation, mavenSessionManager, this.console, prosperoConfig);){
                    prepareCandidateAction.buildUpdate(targetDir, galleonEnv);
                }
            }
            finally {
                System.clearProperty("maven.repo.local");
            }
        }
    }

    public void applyRevert(Path updateDirectory) throws OperationException, ProvisioningException {
        ApplyCandidateAction applyAction = new ApplyCandidateAction(this.installation, updateDirectory);
        if (!applyAction.verifyUpdateCandidate()) {
            throw Messages.MESSAGES.invalidUpdateCandidate(updateDirectory, this.installation);
        }
        applyAction.applyUpdate();
    }

    private static void verifyStateExists(SavedState savedState, InstallationMetadata metadata) throws MetadataException {
        if (!metadata.getRevisions().stream().filter(s -> s.getName().equals(savedState.getName())).findFirst().isPresent()) {
            throw Messages.MESSAGES.savedStateNotFound(savedState.getName());
        }
    }
}

