/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.TemporaryRepositoriesHandler;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class InstallationRestoreAction {
    private final Path installDir;
    private final Console console;
    private final MavenSessionManager mavenSessionManager;

    public InstallationRestoreAction(Path installDir, MavenSessionManager mavenSessionManager, Console console) {
        this.installDir = installDir;
        this.mavenSessionManager = mavenSessionManager;
        this.console = console;
    }

    public void restore(Path metadataBundleZip, List<Repository> remoteRepositories) throws ProvisioningException, IOException, OperationException {
        if (this.installDir.toFile().exists()) {
            throw Messages.MESSAGES.installationDirAlreadyExists(this.installDir);
        }
        try (InstallationMetadata metadataBundle = InstallationMetadata.importMetadata(metadataBundleZip);){
            ProsperoConfig prosperoConfig = metadataBundle.getProsperoConfig();
            ArrayList<Channel> originalChannels = new ArrayList<Channel>(prosperoConfig.getChannels());
            if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
                prosperoConfig.getChannels().clear();
                prosperoConfig.getChannels().addAll(TemporaryRepositoriesHandler.overrideRepositories(originalChannels, remoteRepositories));
            }
            GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installDir, prosperoConfig.getChannels(), this.mavenSessionManager).setConsole(this.console).setRestoreManifest(metadataBundle.getManifest()).build();
            try {
                GalleonUtils.executeGalleon(options -> galleonEnv.getProvisioningManager().provision(metadataBundle.getGalleonProvisioningConfig(), options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
            }
            catch (UnresolvedMavenArtifactException e) {
                throw new ArtifactResolutionException(e, prosperoConfig.listAllRepositories(), this.mavenSessionManager.isOffline());
            }
            this.writeProsperoMetadata(galleonEnv.getRepositoryManager(), originalChannels);
        }
    }

    private void writeProsperoMetadata(ChannelMavenArtifactRepositoryManager maven, List<Channel> channels) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = new InstallationMetadata(this.installDir, manifest, channels);){
            installationMetadata.recordProvision(true);
        }
    }
}

