/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.actions.ApplyCandidateAction;
import org.wildfly.prospero.actions.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.model.ProsperoConfig;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

class PrepareCandidateAction
implements AutoCloseable {
    private final InstallationMetadata metadata;
    private final Path installDir;
    private final Console console;
    private final ProsperoConfig prosperoConfig;
    private final MavenSessionManager mavenSessionManager;

    PrepareCandidateAction(Path installDir, MavenSessionManager mavenSessionManager, Console console, ProsperoConfig prosperoConfig) throws OperationException {
        this.metadata = new InstallationMetadata(installDir);
        this.installDir = installDir;
        this.console = console;
        this.prosperoConfig = prosperoConfig;
        this.mavenSessionManager = mavenSessionManager;
    }

    boolean buildUpdate(Path targetDir, GalleonEnvironment galleonEnv) throws ProvisioningException, OperationException {
        this.doBuildUpdate(targetDir, galleonEnv);
        try {
            SavedState savedState = this.metadata.getRevisions().get(0);
            Files.writeString(targetDir.resolve(ApplyCandidateAction.UPDATE_MARKER_FILE), (CharSequence)savedState.getName(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void doBuildUpdate(Path targetDir, GalleonEnvironment galleonEnv) throws ProvisioningException, OperationException {
        ProvisioningManager provMgr = galleonEnv.getProvisioningManager();
        try {
            GalleonUtils.executeGalleon(options -> {
                options.put("export-system-paths", "true");
                provMgr.provision(ProvisioningXmlParser.parse((Path)PathsUtils.getProvisioningXml((Path)this.installDir)), options);
            }, this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            throw new ArtifactResolutionException(e, this.prosperoConfig.listAllRepositories(), this.mavenSessionManager.isOffline());
        }
        try {
            this.writeProsperoMetadata(targetDir, galleonEnv.getRepositoryManager(), this.metadata.getProsperoConfig().getChannels());
        }
        catch (MetadataException ex) {
            throw new ProvisioningException((Throwable)ex);
        }
    }

    @Override
    public void close() {
        this.metadata.close();
    }

    private void writeProsperoMetadata(Path home, ChannelMavenArtifactRepositoryManager maven, List<Channel> channels) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = new InstallationMetadata(home, manifest, channels);){
            installationMetadata.recordProvision(true, false);
        }
    }
}

