/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.actions.Console;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.RepositoryUtils;
import org.wildfly.prospero.api.exceptions.ArtifactResolutionException;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.api.exceptions.OperationException;
import org.wildfly.prospero.galleon.ChannelMavenArtifactRepositoryManager;
import org.wildfly.prospero.galleon.GalleonArtifactExporter;
import org.wildfly.prospero.galleon.GalleonEnvironment;
import org.wildfly.prospero.galleon.GalleonUtils;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class ProvisioningAction {
    private static final String CHANNEL_NAME_PREFIX = "channel-";
    private final MavenSessionManager mavenSessionManager;
    private final Path installDir;
    private final Console console;

    public ProvisioningAction(Path installDir, MavenSessionManager mavenSessionManager, Console console) {
        this.installDir = installDir;
        this.console = console;
        this.mavenSessionManager = mavenSessionManager;
        ProvisioningAction.verifyInstallDir(installDir);
    }

    public void provision(ProvisioningConfig provisioningConfig, List<Channel> channels) throws ProvisioningException, OperationException, MalformedURLException {
        channels = this.enforceChannelNames(channels);
        GalleonEnvironment galleonEnv = GalleonEnvironment.builder(this.installDir, channels, this.mavenSessionManager).setConsole(this.console).build();
        try {
            GalleonUtils.ProvisioningManagerExecution galleonOp = (pm, options) -> pm.provision(provisioningConfig, options);
            GalleonUtils.executeGalleon(options -> galleonOp.execute(galleonEnv.getProvisioningManager(), options), this.mavenSessionManager.getProvisioningRepo().toAbsolutePath());
        }
        catch (UnresolvedMavenArtifactException e) {
            List<RemoteRepository> repositories = galleonEnv.getChannels().stream().flatMap(c -> c.getRepositories().stream()).map(r -> RepositoryUtils.toRemoteRepository(r.getId(), r.getUrl())).collect(Collectors.toList());
            throw new ArtifactResolutionException(e, repositories, this.mavenSessionManager.isOffline());
        }
        this.writeProsperoMetadata(this.installDir, galleonEnv.getRepositoryManager(), channels);
        try {
            new GalleonArtifactExporter().cacheGalleonArtifacts(galleonEnv.getChannels(), this.mavenSessionManager, this.installDir, provisioningConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProsperoMetadata(Path home, ChannelMavenArtifactRepositoryManager maven, List<Channel> channels) throws MetadataException {
        ChannelManifest manifest = maven.resolvedChannel();
        try (InstallationMetadata installationMetadata = new InstallationMetadata(home, manifest, channels);){
            installationMetadata.recordProvision(true);
        }
    }

    private List<Channel> enforceChannelNames(List<Channel> newChannels) {
        AtomicInteger channelCounter = new AtomicInteger(0);
        return newChannels.stream().map(c -> {
            if (StringUtils.isEmpty((CharSequence)c.getName())) {
                return new Channel(c.getSchemaVersion(), CHANNEL_NAME_PREFIX + channelCounter.getAndIncrement(), c.getDescription(), c.getVendor(), c.getRepositories(), c.getManifestCoordinate(), c.getBlocklistCoordinate(), c.getNoStreamStrategy());
            }
            return c;
        }).collect(Collectors.toList());
    }

    private static void verifyInstallDir(Path directory) {
        if (directory.toFile().isFile()) {
            throw Messages.MESSAGES.dirMustBeDirectory(directory);
        }
        if (!ProvisioningAction.isEmptyDirectory(directory)) {
            throw Messages.MESSAGES.cannotInstallIntoNonEmptyDirectory(directory);
        }
    }

    private static boolean isEmptyDirectory(Path directory) {
        String[] list = directory.toFile().list();
        return list == null || list.length == 0;
    }
}

