/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.aether.artifact.Artifact;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.prospero.Messages;

public class ArtifactUtils {
    public static int compareVersion(Artifact first, Artifact other) {
        return new ComparableVersion(first.getVersion()).compareTo(new ComparableVersion(other.getVersion()));
    }

    public static ChannelManifestCoordinate manifestCoordFromString(String urlGavOrPath) {
        return ArtifactUtils.coordinateFromString(urlGavOrPath, ChannelManifestCoordinate.class);
    }

    public static ChannelCoordinate channelCoordFromString(String urlGavOrPath) {
        return ArtifactUtils.coordinateFromString(urlGavOrPath, ChannelCoordinate.class);
    }

    private static <T extends ChannelMetadataCoordinate> T coordinateFromString(String urlGavOrPath, Class<T> clazz) {
        try {
            try {
                URL url = new URL(urlGavOrPath);
                return (T)((ChannelMetadataCoordinate)clazz.getDeclaredConstructor(URL.class).newInstance(url));
            }
            catch (MalformedURLException e) {
                if (ArtifactUtils.isValidCoordinate(urlGavOrPath)) {
                    String[] gav = urlGavOrPath.split(":");
                    if (gav.length == 2) {
                        return (T)((ChannelMetadataCoordinate)clazz.getDeclaredConstructor(String.class, String.class).newInstance(gav[0], gav[1]));
                    }
                    if (gav.length == 3) {
                        return (T)((ChannelMetadataCoordinate)clazz.getDeclaredConstructor(String.class, String.class, String.class).newInstance(gav[0], gav[1], gav[2]));
                    }
                }
                try {
                    return (T)((ChannelMetadataCoordinate)clazz.getDeclaredConstructor(URL.class).newInstance(Paths.get(urlGavOrPath, new String[0]).toAbsolutePath().toUri().toURL()));
                }
                catch (MalformedURLException e2) {
                    throw Messages.MESSAGES.invalidUrl(urlGavOrPath, e2);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Can't instantiate " + clazz.getSimpleName(), e);
        }
    }

    public static boolean isValidCoordinate(String gav) {
        String[] parts;
        if (gav.contains("\\") || gav.contains("/")) {
            return false;
        }
        for (String part : parts = gav.split(":")) {
            if (!StringUtils.isBlank((CharSequence)part)) continue;
            return false;
        }
        return parts.length == 2 || parts.length == 3;
    }
}

