/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.util.Objects;

public class FileConflict {
    private Change userChange;
    private Change updateChange;
    private Resolution resolution;
    private String relativePath;

    public static AddBuilder userAdded(String path) {
        return new AddBuilder(path);
    }

    public static RemoveBuilder userRemoved(String path) {
        return new RemoveBuilder(path);
    }

    public static ModifyBuilder userModified(String path) {
        return new ModifyBuilder(path);
    }

    private FileConflict(Change userChange, Change updateChange, Resolution resolution, String relativePath) {
        this.userChange = userChange;
        this.updateChange = updateChange;
        this.resolution = resolution;
        this.relativePath = relativePath;
    }

    public Change getUserChange() {
        return this.userChange;
    }

    public Change getUpdateChange() {
        return this.updateChange;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String toString() {
        return "Conflict{userChange=" + this.userChange + ", updateChange=" + this.updateChange + ", resolution=" + this.resolution + ", relativePath='" + this.relativePath + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileConflict conflict = (FileConflict)o;
        return this.userChange == conflict.userChange && this.updateChange == conflict.updateChange && this.resolution == conflict.resolution && Objects.equals(this.relativePath, conflict.relativePath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userChange, this.updateChange, this.resolution, this.relativePath});
    }

    public static class ResolutionBuilder {
        private final Change user;
        private final Change update;
        private final String path;

        private ResolutionBuilder(String path, Change user, Change update) {
            this.user = user;
            this.update = update;
            this.path = path;
        }

        public FileConflict userPreserved() {
            return new FileConflict(this.user, this.update, Resolution.USER, this.path);
        }

        public FileConflict overwritten() {
            return new FileConflict(this.user, this.update, Resolution.UPDATE, this.path);
        }
    }

    public static class AddBuilder {
        private final String path;

        private AddBuilder(String path) {
            this.path = path;
        }

        public ResolutionBuilder updateAdded() {
            return new ResolutionBuilder(this.path, Change.ADDED, Change.ADDED);
        }

        public ResolutionBuilder updateDidntChange() {
            return new ResolutionBuilder(this.path, Change.ADDED, Change.NONE);
        }
    }

    public static class RemoveBuilder {
        private final String path;

        private RemoveBuilder(String path) {
            this.path = path;
        }

        public ResolutionBuilder updateModified() {
            return new ResolutionBuilder(this.path, Change.REMOVED, Change.MODIFIED);
        }

        public ResolutionBuilder updateDidntChange() {
            return new ResolutionBuilder(this.path, Change.REMOVED, Change.NONE);
        }
    }

    public static class ModifyBuilder {
        private final String path;

        private ModifyBuilder(String path) {
            this.path = path;
        }

        public ResolutionBuilder updateModified() {
            return new ResolutionBuilder(this.path, Change.MODIFIED, Change.MODIFIED);
        }

        public ResolutionBuilder updateDidntChange() {
            return new ResolutionBuilder(this.path, Change.MODIFIED, Change.NONE);
        }

        public ResolutionBuilder updateRemoved() {
            return new ResolutionBuilder(this.path, Change.MODIFIED, Change.REMOVED);
        }
    }

    public static enum Resolution {
        USER,
        UPDATE;

    }

    public static enum Change {
        ADDED,
        MODIFIED,
        REMOVED,
        NONE;

    }
}

