/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.Stream;
import org.wildfly.prospero.Messages;
import org.wildfly.prospero.api.InstallationChanges;
import org.wildfly.prospero.api.SavedState;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.installation.git.GitStorage;
import org.wildfly.prospero.model.ManifestYamlSupport;
import org.wildfly.prospero.model.ProsperoConfig;

public class InstallationMetadata
implements AutoCloseable {
    @Deprecated
    public static final String METADATA_DIR = ".installation";
    @Deprecated
    public static final String MANIFEST_FILE_NAME = "manifest.yaml";
    @Deprecated
    public static final String INSTALLER_CHANNELS_FILE_NAME = "installer-channels.yaml";
    public static final String PROVISIONING_FILE_NAME = "provisioning.xml";
    public static final String GALLEON_INSTALLATION_DIR = ".galleon";
    public static final String README_FILE_NAME = "README.txt";
    private static final String WARNING_MESSAGE = "WARNING: The files in .installation directory should be only edited by the provisioning tool.";
    private final Path manifestFile;
    private final Path channelsFile;
    private final Path readmeFile;
    private final Path provisioningFile;
    private ChannelManifest manifest;
    private ProvisioningConfig galleonProvisioningConfig;
    private List<Channel> channels;
    private final GitStorage gitStorage;
    private final Path base;

    private InstallationMetadata(Path manifestFile, Path channelsFile, Path provisioningFile) throws MetadataException {
        this.base = manifestFile.getParent();
        this.gitStorage = null;
        this.manifestFile = manifestFile;
        this.channelsFile = channelsFile;
        this.readmeFile = this.base.resolve(METADATA_DIR).resolve(README_FILE_NAME);
        this.provisioningFile = provisioningFile;
        this.doInit(manifestFile, channelsFile, provisioningFile);
    }

    public InstallationMetadata(Path base) throws MetadataException {
        this(base, new GitStorage(base));
    }

    protected InstallationMetadata(Path base, GitStorage gitStorage) throws MetadataException {
        this.base = base;
        this.gitStorage = gitStorage;
        this.manifestFile = base.resolve(METADATA_DIR).resolve(MANIFEST_FILE_NAME);
        this.channelsFile = base.resolve(METADATA_DIR).resolve(INSTALLER_CHANNELS_FILE_NAME);
        this.readmeFile = base.resolve(METADATA_DIR).resolve(README_FILE_NAME);
        this.provisioningFile = base.resolve(GALLEON_INSTALLATION_DIR).resolve(PROVISIONING_FILE_NAME);
        this.doInit(this.manifestFile, this.channelsFile, this.provisioningFile);
    }

    public InstallationMetadata(Path base, ChannelManifest manifest, List<Channel> channels) throws MetadataException {
        this.base = base;
        this.gitStorage = new GitStorage(base);
        this.manifestFile = base.resolve(METADATA_DIR).resolve(MANIFEST_FILE_NAME);
        this.channelsFile = base.resolve(METADATA_DIR).resolve(INSTALLER_CHANNELS_FILE_NAME);
        this.readmeFile = base.resolve(METADATA_DIR).resolve(README_FILE_NAME);
        this.provisioningFile = base.resolve(GALLEON_INSTALLATION_DIR).resolve(PROVISIONING_FILE_NAME);
        this.manifest = manifest;
        this.channels = channels;
        if (channels != null && channels.stream().filter(c -> StringUtils.isEmpty((CharSequence)c.getName())).findAny().isPresent()) {
            throw Messages.MESSAGES.emptyChannelName();
        }
        try {
            this.galleonProvisioningConfig = ProvisioningXmlParser.parse((Path)this.provisioningFile);
        }
        catch (ProvisioningException e) {
            throw Messages.MESSAGES.unableToParseConfiguration(this.provisioningFile, e);
        }
    }

    private void doInit(Path manifestFile, Path channelsFile, Path provisioningFile) throws MetadataException {
        try {
            this.manifest = ManifestYamlSupport.parse(manifestFile.toFile());
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToParseConfiguration(manifestFile, e);
        }
        try {
            this.channels = ProsperoConfig.readConfig(channelsFile).getChannels();
        }
        catch (MetadataException e) {
            throw Messages.MESSAGES.unableToParseConfiguration(channelsFile, e.getCause());
        }
        try {
            this.galleonProvisioningConfig = ProvisioningXmlParser.parse((Path)provisioningFile);
        }
        catch (ProvisioningException e) {
            throw Messages.MESSAGES.unableToParseConfiguration(provisioningFile, e);
        }
        try {
            if (this.gitStorage != null && !this.gitStorage.isStarted()) {
                this.gitStorage.record();
            }
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToCreateHistoryStorage(this.base.resolve(METADATA_DIR), e);
        }
    }

    public static InstallationMetadata importMetadata(Path location) throws IOException, MetadataException {
        Path manifestFile = null;
        Path channelsFile = null;
        Path provisioningFile = null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(location.toFile()));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals(MANIFEST_FILE_NAME)) {
                    manifestFile = Files.createTempFile("manifest", "yaml", new FileAttribute[0]);
                    Files.copy(zis, manifestFile, StandardCopyOption.REPLACE_EXISTING);
                    manifestFile.toFile().deleteOnExit();
                }
                if (entry.getName().equals(INSTALLER_CHANNELS_FILE_NAME)) {
                    channelsFile = Files.createTempFile("channels", "yaml", new FileAttribute[0]);
                    Files.copy(zis, channelsFile, StandardCopyOption.REPLACE_EXISTING);
                    channelsFile.toFile().deleteOnExit();
                }
                if (!entry.getName().equals(PROVISIONING_FILE_NAME)) continue;
                provisioningFile = Files.createTempFile("provisioning", "xml", new FileAttribute[0]);
                Files.copy(zis, provisioningFile, StandardCopyOption.REPLACE_EXISTING);
                provisioningFile.toFile().deleteOnExit();
            }
        }
        if (manifestFile == null || channelsFile == null || provisioningFile == null) {
            throw Messages.MESSAGES.incompleteMetadataBundle(location);
        }
        return new InstallationMetadata(manifestFile, channelsFile, provisioningFile);
    }

    public Path exportMetadataBundle(Path location) throws IOException {
        File file = location.toFile();
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));){
            int len;
            byte[] buffer;
            zos.putNextEntry(new ZipEntry(MANIFEST_FILE_NAME));
            try (FileInputStream fis = new FileInputStream(this.manifestFile.toFile());){
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(INSTALLER_CHANNELS_FILE_NAME));
            fis = new FileInputStream(this.channelsFile.toFile());
            try {
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
            zos.putNextEntry(new ZipEntry(PROVISIONING_FILE_NAME));
            fis = new FileInputStream(this.provisioningFile.toFile());
            try {
                buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            finally {
                fis.close();
            }
            zos.closeEntry();
        }
        return file.toPath();
    }

    public ChannelManifest getManifest() {
        return this.manifest;
    }

    public ProvisioningConfig getGalleonProvisioningConfig() {
        return this.galleonProvisioningConfig;
    }

    public void recordProvision(boolean overrideProsperoConfig) throws MetadataException {
        this.recordProvision(overrideProsperoConfig, true);
    }

    public void recordProvision(boolean overrideProsperoConfig, boolean gitRecord) throws MetadataException {
        try {
            ManifestYamlSupport.write(this.manifest, this.manifestFile);
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToSaveConfiguration(this.manifestFile, e);
        }
        if (!Files.exists(this.readmeFile, new LinkOption[0])) {
            try {
                FileUtils.writeStringToFile((File)new File(this.readmeFile.toString()), (String)WARNING_MESSAGE, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new MetadataException("Unable to create README.txt in installation", e);
            }
        }
        if (overrideProsperoConfig || !Files.exists(this.channelsFile, new LinkOption[0])) {
            this.writeProsperoConfig();
        }
        if (gitRecord) {
            this.gitStorage.record();
        }
    }

    private void writeProsperoConfig() throws MetadataException {
        try {
            this.getProsperoConfig().writeConfig(this.channelsFile);
        }
        catch (IOException e) {
            throw Messages.MESSAGES.unableToSaveConfiguration(this.channelsFile, e);
        }
    }

    public List<SavedState> getRevisions() throws MetadataException {
        return this.gitStorage.getRevisions();
    }

    public InstallationMetadata rollback(SavedState savedState) throws MetadataException {
        this.gitStorage.revert(savedState);
        return new InstallationMetadata(this.base);
    }

    public InstallationChanges getChangesSince(SavedState savedState) throws MetadataException {
        return new InstallationChanges(this.gitStorage.getArtifactChanges(savedState), this.gitStorage.getChannelChanges(savedState));
    }

    public void setManifest(ChannelManifest resolvedChannel) {
        this.manifest = resolvedChannel;
    }

    public List<Artifact> getArtifacts() {
        return this.manifest.getStreams().stream().map(s -> this.streamToArtifact((Stream)s)).collect(Collectors.toList());
    }

    private DefaultArtifact streamToArtifact(Stream s) {
        return new DefaultArtifact(s.getGroupId(), s.getArtifactId(), "jar", s.getVersion());
    }

    public Artifact find(Artifact gav) {
        for (Stream stream : this.manifest.getStreams()) {
            if (!stream.getGroupId().equals(gav.getGroupId()) || !stream.getArtifactId().equals(gav.getArtifactId())) continue;
            return this.streamToArtifact(stream);
        }
        return null;
    }

    public ProsperoConfig getProsperoConfig() {
        return new ProsperoConfig(new ArrayList<Channel>(this.channels));
    }

    public void updateProsperoConfig(ProsperoConfig config) throws MetadataException {
        this.channels = config.getChannels();
        this.writeProsperoConfig();
        this.gitStorage.recordConfigChange();
    }

    @Override
    public void close() {
        if (this.gitStorage != null) {
            try {
                this.gitStorage.close();
            }
            catch (Exception e) {
                Messages.MESSAGES.unableToCloseStore(e);
            }
        }
    }
}

