/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.api;

import java.time.Instant;
import java.util.Locale;
import java.util.Objects;

public class SavedState {
    private String hash;
    private Instant timestamp;
    private Type type;

    public SavedState(String hash, Instant timestamp, Type type) {
        this.hash = hash;
        this.timestamp = timestamp;
        this.type = type;
    }

    public SavedState(String hash) {
        this.hash = hash;
        this.timestamp = null;
        this.type = null;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.hash;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String shortDescription() {
        return String.format("[%s] %s - %s", this.hash, this.timestamp.toString(), this.type.toString().toLowerCase(Locale.ROOT));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavedState that = (SavedState)o;
        return Objects.equals(this.hash, that.hash) && Objects.equals(this.timestamp, that.timestamp) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hash, this.timestamp, this.type});
    }

    public static enum Type {
        UPDATE,
        INSTALL,
        ROLLBACK,
        CONFIG_CHANGE;

    }
}

